//
//  ContactsFileManager.h
//  ECContactsMgr
//
//  Created by Raymond Shieh on 4/6/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#define _CSV_HAOBO_MATCH_   @"姓名,常用手机,常用邮箱,常用固话,常用传真,公司,生日,昵称,性别,星座,血型,个人主页,E家电话,小灵通,VPN电话,天翼LIVE,QQ,MSN,家庭地址,家庭邮编,家庭传真,家庭固话,部门,职务,公司固话,商务电话,公司邮箱,公司地址,公司邮编,公司主页,备注,商务手机,商务邮箱\n"
#define _CSV_FOXMAIL_MATCH_ @"名,姓,姓名,昵称,电子邮件地址,手机,传呼机,QQ,ICQ,个人主页,性别,生日,爱好,家庭所在国家,家庭所在省,家庭所在市,家庭所在地邮政编码,家庭所在街道,家庭电话1,家庭电话2,家庭传真,公司,公司所在国家,公司所在省,公司所在市,公司所在地邮政编码,公司所在街道,公司网页,职位,部门,办公电话1,办公电话2,公司传真,附注,foxaddrID,foxaddrListMembers\n"
#define _CSV_OUTLOOK_MATCH_ @"\"英文称谓\",\"名\",\"中间名\",\"姓\",\"中文称谓\",\"单位\",\"部门\",\"职务\",\"商务地址 街道\",\"商务地址 街道 2\",\"商务地址 街道 3\",\"商务地址 市/县\",\"商务地址 省/市/自治区\",\"商务地址 邮政编码\",\"商务地址 国家/地区\",\"住宅地址 街道\",\"住宅地址 街道 2\",\"住宅地址 街道 3\",\"住宅地址 市/县\",\"住宅地址 省/市/自治区\",\"住宅地址 邮政编码\",\"住宅地址 国家/地区\",\"其他地址 街道\",\"其他地址 街道 2\",\"其他地址 街道 3\",\"其他地址 市/县\",\"其他地址 省/市/自治区\",\"其他地址 邮政编码\",\"其他地址 国家/地区\",\"助理的电话\",\"商务传真\",\"商务电话\",\"商务电话 2\",\"回电话\",\"车载电话\",\"单位主要电话\",\"住宅传真\",\"住宅电话\",\"住宅电话 2\",\"ISDN\",\"移动电话\",\"其他传真\",\"其他电话\",\"寻呼机\",\"主要电话\",\"无绳电话\",\"TTY/TDD 电话\",\"电报\",\"Internet 忙闲\",\"办公地点\",\"地点\",\"电子邮件地址\",\"电子邮件类型\",\"电子邮件显示名称\",\"电子邮件 2 地址\",\"电子邮件 2 类型\",\"电子邮件 2 显示名\",\"电子邮件 3 地址\",\"电子邮件 3 类型\",\"电子邮件 3 显示名\",\"附注\",\"工作证号码\",\"关键词\",\"记帐信息\",\"纪念日\",\"经理姓名\",\"类别\",\"里程\",\"敏感度\",\"目录服务器\",\"配偶\",\"其他地址 - 邮箱\",\"商务地址 - 邮箱\",\"身份证编号\",\"生日\",\"私有\",\"缩写\",\"网页\",\"性别\",\"业余爱好\",\"引用者\",\"用户 1\",\"用户 2\",\"用户 3\",\"用户 4\",\"优先级\",\"语言\",\"帐户\",\"职业\",\"助理的姓名\",\"住宅地址 - 邮箱\",\"子女\"\n"
#define _VCARD_START_ @"BEGIN:VCARD\nVERSION:3.0\n"
#define _VCARD_END_   @"END:VCARD\n"

enum _CP_FILE_TYPE_ {
    CSV_HaoBo = 1100,
    CSV_Foxmail,
    CSV_Outlook,
    vCard
    };

@interface ContactsFileManager : NSObject {
    NSMutableArray *numbersExisted;
}

@property (nonatomic,retain) NSMutableArray *numbersExisted;

/**
	@brief Exports the contact persons record of current user as a file.
	@param contactPersons: An array of contact person objects (class Contact).
	@param filePath: The file path which selected by user will store the records.
	@param type: The file storage type (CSV or vCard).
	@returns: If exporting is successful, return YES. Otherwise, return NO.
 */
- (BOOL)exportContactPerson:(NSArray *)contactPersons
                     toFile:(NSString *)filePath
                 asFileType:(NSInteger)type;

/**
	@brief Imports the contact persons record from file for current user.
	@param fileAtPath: The target file path.
	@param userId: The user Id of current user.
	@returns: If importing is successful and no existed numbers, return 0. If importing is failed, return NSNotfound. return the numbers existed count.
    *Description: If the contact person is exist, overwrite it. If not, added it to the current user.If the number of importing numbers is equal to the 
                  number of contacts to be overwrited, return negative.
 */
- (NSInteger)importContactPersonFromFile:(NSString *)fileAtPath
                            forUser:(NSString *)userId;

/**
	@brief 覆盖导入联系人时重复号码的记录。需要在调用importContactPersonFromFile:forUser:后调用。
	@returns 成功返回YES，失败返回NO；
 */
- (BOOL)overwriteContactPerson;


@end
