//
//  ECDataMgr.h
//  ECDataMgr
//
//  Created by Ciml on 11-11-14.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#define APPSUPPORTPATH	@"ESurfingClient/"
#define USERDATAPATH @"UserData/%@"
#define CONFIGFILEPATH	@"Config/"
#define CURRENT_USERINFO_FILE_NAME	@"CurrentUser.xml"
#define USERINFO_KEY_UID	@"CurUid"
#define USERINFO_KEY_UTK	@"CurUtk"
#define ENCRYPTKEY			@"codinglife36290"

/**
	@brief SmsDataMgr,ContactDataMgr,MessageDataMgr 3个数据管理模块的父类，此类应为虚类，不要实例化。但主程序启动时，要调用到此类的类方法，以初始化，各模块数据管理类单例，貌似不是很合理。
 
    在实际应用中，本类被实例化为一单例，保存唯一的用户标识。各子类通过类方法获取单例再获取CurrentUid,CurrentUtk.
 */
@interface DataMgr : NSObject {

	/**
	数据保存类型 
	 可供选择的类型有：
	 NSSQLiteStoreType
	 NSXMLStoreType
	 NSBinaryStoreType
	 NSInMemoryStoreType
	 */
	NSString *storeType;

	/**
	要保存的数据文件的文件名（扩展名可选）
	 */
	NSString *databaseName;
	/**
        当前用户的唯一标识（数据访问的必要依据，初始化类对象后必须设置其值,且只需设置一次）
	 */
	NSString *currentUid;
	
	/**
		当前用户的Token
	 */
	NSString *currentUtk;
	
	/**
	 CoreData中负责数据文件存储的对象
	 */
	NSPersistentStoreCoordinator *persistentStoreCoordinator;
	
@private

	
	/**
	 数据模型文件名（不包括扩展名）
	 */
	NSString *dataModelName;
	
    /**
	CoreData中负责管理数据模型的对象
	 */
	NSManagedObjectModel *managedObjectModel;

    /**
 	CoreData中ManagedObjectModel对象的集合
	 */
	NSManagedObjectContext *managedObjectContext;

}



@property (nonatomic, retain) NSString *storeType;
@property (nonatomic, retain) NSString *databaseName;
@property (nonatomic, retain) NSString *dataModelName;
@property (nonatomic, retain) NSString *currentUid;
@property (nonatomic, retain) NSString *currentUtk;

@property (nonatomic, retain, readonly) NSManagedObjectContext *managedObjectContext;
@property (nonatomic, retain, readonly) NSManagedObjectModel *managedObjectModel;
@property (nonatomic, retain, readonly) NSPersistentStoreCoordinator *persistentStoreCoordinator;

/**
	返回一个数据管理单例
	@returns 数据管理单例
 */
+ (DataMgr *)defaultDataMgr;

/**
	公共方法
	产生一个GUID字符串
	@returns GUID（UUID)
 */
+ (NSString*)UUIDString;

/**
	公共方法
	用指定的Key加密字符串
	@param strOrigin 原始字符串
	@param strKey 加密用的Key
	@returns 加密后的字符串
 */
+ (NSString *)encryptString:(NSString *)strOrigin withKey:(NSString *)strKey;

/**
	公共方法
	用指定的Key解密字符串
	@param strCrypted 经过加密的字符串
	@param strKey 解密用的字符串
	@returns 原始字符串
 */
+ (NSString *)decryptString:(NSString *)strCrypted withKey:(NSString *)strKey;

/**
	保存对数据（ManagedObjectContext）更改
	@returns 操作结果
 */
- (BOOL)saveChanges;

/**
	获取程序数据支持目录指向ESurfingClient
	@returns 程序数据支持目录
 */
- (NSString *)applicationSupportDirectory;

/**
	获取配置文件路径
	@returns 配置文件路径
 */
- (NSString *)getConfigFilePath;

/**
	返回保存当前用户数据的路径
	@returns 用户数据保存路径
 */
- (NSString *)getCurrentUserDataPath;

/**
	统一删除接口，从数据库永久删除对象
	@param obj 要删除的对象
	@returns 操作结果
 */
- (BOOL)removeObject:(NSManagedObject *)obj;

/**
	设置当前登陆用户的标识，并保存到本地
	@param strUid 用户标识
	@returns YES-保存成功，NO-保存失败
 */
+ (BOOL)setCurrentUserId:(NSString *)strUid;

/**
	设置当前登陆用户的Token,并保存到本地
	@param strUtk 用户Token
	@returns YES-保存成功，NO-保存失败
 */
+ (BOOL)setCurrentUserToken:(NSString *)strUtk;

/**
	获取当前用户的标识
	@returns 用户标识
 */
- (NSString *)getCurrentUserId;

/**
	获取当前用户的Token
	@returns 用户Token
 */
- (NSString *)getCurrentUserToken;


@end
