//
//  ECConfigTable.h
//  ECDataMgr
//
//  Created by gdcn on 11-10-20.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//
//

#import <Foundation/Foundation.h>

#define _NetworkOptionName       @"NetworkProfile"       /*!< 网络设置字典名 */
#define _PassportOptionName      @"PassportProfile"      /*!< Passport登录信息字典名 */
#define _PrefermenceOptionName   @"Prefermence"          /*!< 基本设置字典名 */
#define _PinManageOpationName    @"PINCodeManagement"    /*!< PIN管理设置字典名，程序中暂时没有用到 */


/*!
* @brief 网络相关设置子项名定义
*/
#define _Network_3G              @"3G"                       /*!< 3G设置信息 */
#define _Network_ADSL            @"ADSL"                     /*!< ADSL设置信息 */
#define _Network_AutomaticConnection @"AutomaticConnection"  /*!< 自动连接设置信息 */
#define _Network_WiFi            @"WiFi"                     /*!< WiFi设置信息 */
#define _Network_Wireless        @"Wireless"                 /*!< 家庭无线帐号信息 */

/*!
* @brief Passport相关设置子项定义
*/
#define _Passport_Account        @"Account"                  /*!< 帐号列表 */
#define _Passport_Password       @"Passowrd"                 /*!< 密码列表 */
#define _Passport_AutoLogin      @"AutoLogin"                /*!< 自动登录标志 */
#define _Passport_KeepPassword   @"KeepPassword"             /*!< 保存密码标志 */
#define _Passport_KeepUserName   @"KeepUserName"             /*!< 保存帐号标志 */

/*!
 * @brief 基本设置相关信息
 */
#define _Prefermence_AutoStart           @"AutoStart"            /**< 自启动设置 */
#define _Prefermence_DoNotNotifyWhenSave @"DoNotNotifyWhenSave"  /**< */
#define _Prefermence_PostSystemMessage   @"PostSystemMessgae"    /**< */
#define _Prefermence_QuitWhenClose       @"QuitWhenClose"        /**< 关闭直接退出 */
#define _Prefermence_WelcomeFirst        @"WelcomeFirst"         /**< 显示欢迎界面 */

/**
 @brief 自动连接相关设置
 */
#define _AUTO_KEY_AUTO_         @"ConnectVia3GIfWiFiLost"       /**< WiFi断线后自动连接3G */
#define _AUTO_KEY_REMIND_       @"NotifySwitchToWiFi"           /**< 有WiFi信号时自动提示连接WiFi */
#define _AUTO_KEY_LIST_         @"NetworkConnectionPriority"    /**< 自动连接选项 */


/**
    家庭无线连接设置关键字定义 
  */
 #define _WLAN_KEY_SSID_             @"NetworkSSID"     /**< 无线SSID */
 #define _WLAN_KEY_WLAN_KEY_         @"NetworkKey"      /**< 无线KEY */
 #define _WLAN_KEY_ACCOUNT_          @"UserName"        /**< pppoe拨号用户名 */
 #define _WLAN_KEY_PASSWORD_         @"Password"        /**< pppoe拨号用户密码 */
 #define _WLAN_KEY_KEEP_PASSWORD_    @"KeepPassword"    /**< 保存密码标志 */
 #define _WLAN_KEY_KEEP_WLAN_KEY_    @"KeepKey"         /**< 保存无线KEY标志 */

/**
    VPDN设置关键字定义
 */
#define _VPDN_KEY_ACCOUNT_      @"Account"      /**< VPDN用户名 */
#define _VPDN_KEY_PASSWORD_     @"Password"     /**< 用户密码 */
#define _VPDN_KEY_KEEP_         @"KeepPassword" /**< 保存密码标志 */
#define _VPDN_KEY_ACTIVE_       @"Active"       /**< 激活标志，如果没有激活则表示不使用VPDN拨号 */


@interface ECConfigTable : NSObject {
@private
    NSMutableDictionary*    configDictionary;
    NSString*               configFileName;
    
    NSDictionary*           urlDictionary;
}

//@property (assign) NSMutableDictionary* configDictionary;

- (BOOL)loadData:(NSString*)fileName;

- (id)configForKey:(id)keyName;

- (void)setConfig:(id)config forKey:(id)key;

- (BOOL)save;

- (NSMutableDictionary *)configDictionary;

/**
	获取Url配置字典
	@returns 成功返回字典对象,失败返回nil
 */
- (NSDictionary*)urlDictionary;


/**
	根据名称获取url地址
	@param keyPath key名称
	@returns 找到返回相对应的url对此，失败返回nil
 */
- (NSString*)urlWithKeyPath:(NSString*)keyPath;


@end
