//
//  ECContactDataMgr.h
//  ECDataMgr
//
//  Created by Ciml on 11-11-14.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "DataMgr.h"
#import "Sync.h"

@class Contact;
@class ContactGroup;

/**
	更改类型
 */
typedef enum _changeType {
	Insert_Change, /**< 插入 */
	Update_Change, /**< 修改 */
	Delete_Change /**< 删除 */
}	ChangeType;

typedef enum{
	ContactObject,
	GroupObject
}	ObjectType;
/**
	联系人数据管理类
 */
@interface ECContactDataMgr : DataMgr {
    Sync* m_sync;
	
}


/**
	获取联系人数据管理单例
	@returns 联系人数据管理类实例
 */
+ (ECContactDataMgr *)defaultContactDataMgr;

/**

	创建新的联系人，此操作将向数据库插入新的记录
	@returns 联系人数据模型对象
 */
+ (Contact *)newContact;

/**
	创建新的分组，此操作将向数据库插入新的记录
	@returns 分组数据模型对象
 */
+ (ContactGroup *)newContactGroup;


// 实例方法

/**
	添加联系人到数据库
	@param contact 联系人对象
	@returns YES-成功,NO-失败
 */
- (BOOL)addNewContact:(Contact *)contact;

/**
	从数据库中彻底删除联系人（不可恢复）
	@param contact 要删除的联系人
	@returns YES-成功，NO-失败
 */
- (BOOL)removeContact:(Contact *)contact;

/**
	添加分组到数据库
	@param group 分组对象
	@returns YES-成功，NO-失败
 */
- (BOOL)addGroup:(ContactGroup *)group;

/**
	从数据库中彻底删除分组，分组中的联系人不会被删除，若联系人不再属于其他分组，则联系人被移到未分组联系人中
	若联系人同时属于其它分组，不会受影响。
	@param group 要删除的分组
	@returns YES-删除成功，NO-删除失败,些方法未保存修改到本地
 */
- (BOOL)removeGroup:(ContactGroup *)group;

/**
	查询数据库中是否存在指定ID的对象
	@param strId GUID字符串
	@returns YES-存在，NO-不存在
 */
- (BOOL)haveObjectWithId:(NSString *)strId;

/**
	获取指定类型指定id的对象
	@param objType 对象类型 Contact OR Group
	@param objId 对象ID
	@returns 如果存在指定对象刚返回对象，不存在返回nil
 */
- (NSManagedObject *)getObject:(ObjectType)objType withGUID:(NSString *)objId;


/**
	获取指定分组的联系人
	@param group 分组对象
	@returns 属于此分组的所有联系人的数组,失败时返回nil
 */
- (NSArray *)getContactsInGroup:(ContactGroup *)group;

/**
	获取所有联系人（包括已删除的联系人）
	@returns 包含所有联系人的数组,失败时返回nil;
 */
- (NSArray *)getAllContacts;

/**
	获取所有分组
	@returns 包含所有分组的数组,失败时返回nil
 */
- (NSArray *)getAllGroups;

/**
	根据号码获取指定联系人
	@param number 电话号码（可以是固话）
	@returns 联系人，失败时返回nil
 */
- (Contact *)getContactWithPhoneNumber:(NSString *)number;
/**
	获取尚未保存更改的对象集合
	@returns 未保存更改的对象集合
 */
- (NSSet *)changedObjects:(ChangeType)type;

/**
 保存修改
 @returns YES-保存成功，NO-保存失败
 */
//- (BOOL)saveChanges;

/**
	回滚操作，放弃更改
 */
- (void)rollBack;


- (void)initSync;
- (void)sync;
- (long)syncState;

- (void)saveOper;

- (NSArray*)queryAllGroupsOrderbyIdAsc;
- (NSInteger)QueryContactCountByGroupId:(NSString*)Id;

@end
