//
//  ECDataCenter.h
//  ECDataMgr
//
//  Created by gdcn on 11-10-20.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#define APPDATAPATH @"ESurfingClient/"
#define USERCONFIGDATAPATH @"Config/"
#define USERLOGDATAPATH @"Log/"


/** 共享Key定义 */
#define SHARE_MEMORY_NETINFO        @"NetInfo"      /** 网络信息 */
#define SHARE_MEMORY_PASSPORTINFO   @"PassportInfo" /** Passport信息 */
#define SHARE_MEMORY_VERSIONINFO    @"VersionInfo"  /** 版本信息 */

#import "ECConfigTable.h"
#import "ECLog.h"

@interface ECDataCenter : NSObject {
@private
    NSString* dataPath;
	
	NSMutableDictionary* memoryData;
    ECLog*    logFile;
}

+ (id)defaultCenter;

- (int)initTables;

- (id)userInfoTable;

- (ECConfigTable*)configTable;

- (id)smsDatabase;

- (id)contactsDatabase;

- (id)recentTable;

/**
	获取用户数据目录
	@returns 用户数据目录
 */
- (NSString*)getDataPath;


/**
	内存数据，供各模块共享
    keys请参考共享Key定义
	@return 内存共享字典
 */
- (NSMutableDictionary*)memoryDictionary;

/**
	获取日志操作类对象
	@returns 日志操作对象
 */
- (id)LogFile;

@end
