//
//  ECLog.h
//  TokenTest
//
//  Created by gdcn on 11-12-30.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
	以读写方式打开一文件,c接口形式的
	@param fileName 文件完整路径
	@returns 成功返回文件句柄,失败返回-1
 */
int openLogFile(const char* fileName);

/**
	添加日志,c接口形式的
    @param file 文件句柄
	@param pLogData 日志内容
	@param nBytes 日志长度
	@returns 失败返回-1,成功返回写入数据长度
 */
int writeLog(int file, const char* pLogData, size_t nBytes);

/**
	关闭文件
	@param file 文件句柄
 */
void closeLogFile(int file);

/**
	获取文件大小
	@param fileName 文件完整路径
	@returns 文件大小
 */
off_t getFileSize(const char* fileName);





/**
	OC形式的日志处理类
 */
@interface ECLog : NSObject {

@private
    int fileHandle;
}

/**
	初始化日志对象,并打开日志文件
	@param fileName 日志文件名
	@returns 成功返回日志处理对象,失败返回nil
 */
- (id)initWithFileName:(NSString*)fileName;


/**
	写入一行日志
	@param logData 日志内容
	@returns 成功返回YES，失败返回NO
 */
- (Boolean)WriteLog:(NSString*)logData;

@end
