//
//  ECMessageMgr.h
//  ECDataMgr
//
//  Created by Ciml on 11-11-30.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//


#import <Cocoa/Cocoa.h>
#import "DataMgr.h"

@class ECSms;
@class ECRecentContact;
@class ECSystemMessage;
@class ECPakageMessage;
@class ECSmsDataMgr;


/**
	消息类型
 */
typedef enum tag_msgType {
    AllMsg, /**< 全部消息 */
	ChatMsg, /**< SIP短信聊天消息 */
	PakageMsg, /**< 套餐消息 */
	SystemMsg /**< 系统消息 */
}	MessageType;


/**
	搜索的时间范围
 */
//Modified by Raymond Shieh, 20120625
typedef enum tag_searchRange {
	AllRange, /**< 所有时间 */
    Weekly, /**< 一周内 */
	Monthly, /**< 一月内 */
	ThreeMonth, /**< 三月内 */
} SearchRange;
//typedef enum tag_searchRange {
//	Weekly, /**< 一周内 */
//	Monthly, /**< 一月内 */
//	ThreeMonth, /**< 三月内 */
//	AllRange /**< 所有时间 */
//} SearchRange;


/**
	消息数据管理类(后期就优化此类，当前版本本类处理 系统消息、套餐消息 以及 SIP短信数据，并且短信数据是由ECSmsDataMgr管理的，这显然是不合理的）
 */

@interface ECMessageDataMgr : DataMgr
 {
	 
	 /**
 	设置此变实属无奈啊，由于时间紧先这样了，如果时间充分可将此类改成复合类，包含MessageDataMgr,SmsDataMgr,ContactDataMgr三个类。此类作为模块统一出口。
	  */
	 ECSmsDataMgr *smsDataMgr;

}



/**
	默认的消息数据管理器,请不要使用 alloc init 方法来得到一个新的ECMessageDataMgr实例
	@returns 消息数据管理器单例
 */
+ (ECMessageDataMgr *)defaultMessageDataMgr;

/**
	创建新的套餐消息
	@returns 套餐消息实例
 */
+ (ECPakageMessage *)newPakageMsg;

/**
	创建新的系统消息
	@returns 系统消息实例
 */
+ (ECSystemMessage *)newSystemMsg;



/**
	获取套餐消息
	@param bAsce 是否按时间升序 YES-升序，NO-降序
	@returns 成功返回数组对象，失败时返回nil;
 */
- (NSArray *)getPakageMsgListAscendByDate:(BOOL)bAsce;

/**
	获取系统消息
	@param bAsce 是否按时间升序 YES-升序，NO-降序
	@returns 成功返回数组对象，失败时返回nil;
 */
- (NSArray *)getSystemMsgListAscendByDate:(BOOL)bAsce;

/**
	获取USIM卡上的短信
	@returns 失败时返回nil;
 */
- (NSArray *)getUIMMsgList;
//
//
///**
//	删除指定套餐消息
//	@param pkgMsg 套餐消息
//	@returns 成功返回YES，失败时返回NO。
// */
//- (BOOL)removePakageMsg:(ECPakageMessage *)pkgMsg;
//
///**
//	删除指定系统消息
//	@param sysMsg 系统消息
//	@returns 成功返回YES，失败时返回NO。
// */
//- (BOOL)removeSystemMsg:(ECSystemMessage *)sysMsg;

/**
	删除指定ID的UIM短消息
	@param msgId 短消息ID
	@returns 成功返回YES，失败时返回NO。
 */
- (BOOL)removeUIMMsgWithMsgID:(NSString *)msgId;


/**
	按指定条件搜索消息
	@param eRype 消息类型 
 ChatMsg	SIP短信聊天消息
 PakageMsg	套餐消息
 SystemMsg	系统消息
 AllMsg		所有消息
	@param eRange 搜索时间范围
 Weekly		最近一周
 Monthly	最近一个月
 ThreeMonth	最近三个月
 AllRange	全部
	@param strKeyword 搜索关键字
	@param bAsce 是否按时间升序排列
 @returns 搜索结果，包含指定类型的对象数组，若Type为AllMsg,则返回的数组包含3个数组对象，分别为SIP短信数组，套餐消息数组，系统消息数组。
 3个数组均不为nil，但有可能为空数组。失败时返回nil。
 */
- (NSArray *)searchMsgWithType:(MessageType)eRype
						 range:(SearchRange)eRange
					   keyword:(NSString *)strKeyword
						ascend:(BOOL)bAsce;


/**
	搜索从指定时间起的
	@param oldDate 搜索的起始时间
	@param strKeyword 搜索关键字
	@param bAsce 是否按时间升序
	@returns 搜索结果，注意：返回的数组包含3个数组对象，分别为SIP短信数组，套餐消息数组，系统消息数组。
	3个数组均不为nil，但有可能为空数组。
 */
- (NSArray *)searchAllMsgFromDate:(NSDate *)oldDate
					  withKeyword:(NSString*)strKeyword
						   ascend:(BOOL)bAsce;

#pragma mark -
#pragma mark 短信
// 短信数据操作全部由SmsDataMgr负责。所有函数只是简章的调用了ECSmsDataMgr的方法。

/**
 新建短信记录，此方法将在数据库中插入新的记录
 @returns 短信数据模型实例
 */
+ (ECSms *)newSms;

/**
 新建最近联系人记录，此方法将在数据库中插入新的记录
 @returns 最近联系人数据模型实例
 */
+ (ECRecentContact *)newRecentContact;


/**
 获取符合指定条件的短信记录
 @param strMobile 电话号码（聊天对象的标识）,传nil,返回所有接收到的短信
 @param nCount 要获取的记录数量 0-所在符合条件的记录
 @param nReadState 记录的读取状态 0-未读， 1-已读 ，99-全部
 @param bDesc 排序方式（按时间） YES-降序，NO-升序
 @returns 取符合指定条件的短信记录
 */
- (NSArray *)getSmsRecordsByMobile:(NSString *)strMobile count:(NSUInteger)nCount readState:(NSInteger)nReadState descend:(BOOL)bDesc;


/**
 获取符合指定条件的短信记录
 @param strMobile 电话号码（聊天对象的标识）,传nil,返回所有接收到的短信
 @param nCount 要获取的记录数量 0-所有符合条件的记录	
 @param offset 指定一个偏移量，从此偏移值开始返回指定数量的记录
 @param nReadState 记录的读取状态 0-未读， 1-已读 ，99-全部
 @param bDesc 排序方式（按时间） YES-降序，NO-升序
 @returns 取符合指定条件的短信记录ECSms
 */
- (NSArray *)getSmsRecordsByMobile:(NSString *)strMobile count:(NSUInteger)nCount offset:(NSUInteger)offset readState:(NSInteger)nReadState descend:(BOOL)bDesc;

/**
 获取指定条件的记录条数
 @param strMobile 电话号码（聊天对象的标识）,传nil,返回所有接收到的短信
 @param nReadState 记录的读取状态 0-未读， 1-已读 ，99-全部
 @returns SIP短信条数
 */
- (NSUInteger)getSmsRecordsCountByMobile:(NSString *)strMobile readState:(NSInteger)nReadState;

/**
 设置短信记录的读取状态
 @param sms 要修改读取状态的短信对象
 @param bReadState 读取状态 YES-已读，NO-未读
 @returns 操作结果 YES-成功，NO-失败
 */
- (BOOL)setSms:(ECSms *)sms readed:(BOOL)bReadState;

/**
 通过id查找短信对象
 @param id 短信的id
 @returns 短信对象
 */
- (ECSms*)getSmsRecordById:(NSString*)id;

/**
 设置短信记录的读取状态
 @param bReaded 读取状态 YES-已读，NO-未读
 @param id 要修改读取状态的短信的id
 @returns 操作结果 YES-成功，NO-失败
 */
- (BOOL)UpdateSmsReadStatus:(BOOL)bReaded ById:(NSString*)id;

/**
 获取最近联系人列表
 @param nCount 要获取的记录条数
 @param bDesc 按时间的排序方式 YES-降序，NO-升序
 @returns 最近联系人列表
 */
- (NSArray *)getRecentContactsListWithCount:(NSInteger)nCount descend:(BOOL)bDesc;

/**
 添加记录到最近联系人列表，若电话号码已存在于列表中，刚视为更新记录时间。
 @param strMobile 电话号码
 @param strName 联系人姓名
 @returns 操作结果 YES-成功，NO-失败
 */

- (BOOL)insertToRecentContactsWithMobile:(NSString*)strMobile name:(NSString*)strName;

- (void)updateRecentContactWithMobile:(NSString*)strMobile Name:(NSString*)strName;
- (void)removeRecentContactByMobile:(NSString*)strMobile;


/**
 从指定时间开始搜索短信
 @param oldDate 时间下限，搜索从此时间到现在的时间段内发生的短信
 指定nil，则无时间限制。
 @param strKeyword 搜索关键字
 @param bAscend 排序方式 YES-升序，NO-降序
 @returns 搜索结果
 */
- (NSArray *)searchMsgFromDate:(NSDate *)oldDate withKeyword:(NSString *)strKeyword ascend:(BOOL)bAscend;

#pragma mark 公用接口

/**
	保存消息到数据库
	@param msg 要保存的消息
	@returns 操作结果
 */
- (BOOL)saveMsg:(NSManagedObject *)msg;

/**
	删除消息
	@param msg 要删除的消息
	@returns 操作结果
 */
- (BOOL)removeMsg:(NSManagedObject *)msg;


@end
