//
//  ECProvinceMgr.h
//  ECNetMgr
//
//  Created by gdcn on 11-10-27.
//  Copyright 2011年 CDC. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface ECProvinceMgr : NSObject {
@private
    NSDictionary* provinceInfo;
    NSMutableDictionary*    numberProvince;
    NSArray*                arrProvinceName;
    NSArray*                arrKeyOrder;
}

+ (id)defaultProvinceMgr;

/**
	查找号码所在省份名
	@param number 号码
	@returns 找到返回省份名,没找到返回nil
 */
- (NSString*)provinceNameForNumber:(NSString*)number;


/**
	根据省份名返回省份编码
	@param name 省份名
	@returns 找到返回省份编码，没找到返回默认省份编码
 */
- (NSString*)provinceCodeForName:(NSString*)name;


/**
	根据省份编码返回省份名
	@param code 省份编码
	@returns 找到返回省份名，没找到返回默认省份名
 */
- (NSString*)provinceNameForCode:(NSString*)code;


- (NSArray*)getProvinces;

@end
