//
//  ECSms.h
//  ECDataMgr
//
//  Created by CodingLife on 11-11-14.
//  Copyright 2011 中数通信息有限公司. All rights reserved.
//

#import <CoreData/CoreData.h>

/**
 短信类型
 */
typedef enum enum_smsType {
	SmsType_Draft, /**< 草稿 */
	SmsType_Sended, /**< 已发送 */
	SmsType_Recieved /**< 已接收 */
} SmsType;

/**
 短信数据模型
 */
@interface ECSms :  NSManagedObject

{
}

/**
 讲到状态，0-未读，1-已读
 */
@property (nonatomic, retain) NSNumber * readStatus;

/**
	短信GUID 唯一标识
 */
@property (nonatomic, retain) NSString * smsGUID;
/**
	短信内容
 */
@property (nonatomic, retain) NSString * smsContent;
/**
	发送者号码，当发送者为自己时可能为空
 */
@property (nonatomic, retain) NSString * senderPhoneNumber;
/**
	招收者号码，当接收者为自己时可能为空
 */
@property (nonatomic, retain) NSString * recieverPhoneNumber;
/**
	发送时间
 */
@property (nonatomic, retain) NSDate * sendTime;
/**
 短信类型SmsType
 */
@property (nonatomic, retain) NSNumber * smsType;

/**
	短信ID
 */
@property (nonatomic, retain) NSString * smsId;
/**
	接收者姓名
 */
@property (nonatomic, retain) NSString * recieverName;
/**
	发送者姓名
 */
@property (nonatomic, retain) NSString * senderName;

@end



