//
//  MessageFileManager.h
//  ECDataMgr
//
//  Created by Lone on 12-5-7.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

enum _MESSAGE_TYPE_ {
    mt_Sms = 1200,
    mt_SystemMessage,
    mt_PakageMessage
};

#define _SMS_DB_MATCH_ @"ΩsmsΩ"
#define _PAKAGEMESSAGE_DB_MATCH_ @"ΩpakageMessageΩ"
#define _SYSTEMMESSAGE_DB_MATCH_ @"ΩsystemMessageΩ"

@interface MessageFileManager : NSObject {
    
}

/**
 @brief Exports the messages record of current user as a file.
 @param messages: An array of message objects.
 @param messageType:type of message which will be exported(Sms or SystemMessage or PakageMessage)
 @param filePath: The file path which selected by user will store the records.
 @param isTextType: If YES, it means save as text type. Otherwise exports the SQLite file.
 @returns: If exporting is successful, return YES. Otherwise, return NO.
 */
- (BOOL)exportMessages:(NSArray *)messages
         ofMessageType:(NSUInteger)messageType
                toFile:(NSString *)filePath
            asTextType:(BOOL)isTextType;

/**
 @brief Imports the messages record to current user from a file.
 @param fileAtPath: The target file path.
 @param userId: The user Id of current user.
 @returns: If importing is successful, return YES. Otherwise, return NO.
 */
- (BOOL)importMessagesFromFile:(NSString *)fileAtPath
                       forUser:(NSString *)userId;

@end
