//
//  SmsFileManager.h
//  ECDataMgr
//
//  Created by Raymond Shieh on 4/6/12.
//  Copyright (c) 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface SmsFileManager : NSObject {
    
}

/**
 @brief Exports the messages record of current user as a file.
 @param messages: An array of message objects (class ECSms).
 @param filePath: The file path which selected by user will store the records.
 @param isTextType: If YES, it means save as text type. Otherwise exports the SQLite file.
 @returns: If exporting is successful, return YES. Otherwise, return NO.
 */
- (BOOL)exportMessages:(NSArray *)messages
                toFile:(NSString *)filePath
            asTextType:(BOOL)isTextType;

/**
 @brief Imports the messages record to current user from a file.
 @param fileAtPath: The target file path.
 @param userId: The user Id of current user.
 @returns: If importing is successful, return YES. Otherwise, return NO.
 */
- (BOOL)importMessagesFromFile:(NSString *)fileAtPath
                       forUser:(NSString *)userId;

@end
