//
//  Sync.h
//  ECDataMgr
//
//  Created by me on 4/20/12.
//  Copyright 2012 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#define MSG_BEGIN_SYNC @"MSG_BEGIN_SYNC"
#define MSG_PARSE_SYNC_RESULT   @"MSG_PARSE_SYNC_RESULT"


@class Contact;
@class ContactGroup;


@interface Sync : NSObject
{
    
@private
    
    NSMutableString* m_strSyncLocalTempFile;
    NSMutableString* m_strSyncServerTempFile;
    id m_ECContactDataMgr;
    id m_urlcon;
    NSMutableData *responseData;
    long m_nSyncState;
}

@property (nonatomic, assign) long m_nSyncState;
@property (nonatomic, retain) id m_urlcon;
@property (nonatomic, retain) NSMutableData *responseData;
@property (nonatomic, retain) NSMutableString* m_strSyncLocalTempFile;
@property (nonatomic, retain) NSMutableString* m_strSyncServerTempFile;

#pragma mark-
#pragma mark 通讯录同步相关

/*
 */
- (BOOL)initWithECContactDataMgr:(id)mgr;

- (NSXMLDocument*)getSyncLocalTempXmlDoc;
- (NSString*)getLastSyncTime;
- (NSXMLElement *)createContactXMLElement:(Contact *)ct WithOperType:(NSInteger)nType;
- (NSXMLElement *)createGroupXMLElement:(ContactGroup *)gp WithOperType:(NSInteger)nType;
- (void)saveOperWithContact:(Contact *)contact OperType:(NSInteger)nType;
- (void)saveOperWithGroup:(ContactGroup *)group OperType:(NSInteger)nType;
- (void)clearGroupTable;
- (void)clearContactTable;
- (void)parseSyncResult;
- (NSInteger)QueryContactCountByGroupId:(NSString*)Id;
- (NSString*)string2Md5:(NSString*)strSrc;
- (NSString*)verifyCode;
- (void)sync;
- (void)postSynState:(long)nState;


- (void)onMsgBeginSync:(NSNotification*)notification;
- (void)onMsgParseSyncResult:(NSNotification*)notification;

@end
