//
//  ECNetConn.h
//  ECNetMgr
//
//  Created by gdcn on 11-10-18.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//
/**
 * @file    ECNetConn.h
 * @brief   网络连接协议接口
 * @author  liw
 * @date    2011-10-18
 * @version  v1.0
 */
#import <Foundation/Foundation.h>

#ifndef __ECConn__H__
#define __ECConn__H__

#define _CdmaServiceName	CFSTR("USB-KEY DAIL")

/*!
 * @brief 网络类型定义
 */
enum _ECConnectType{
    unknownNetwork = -1,    /**< 未知网络 */
    otherNetwork = 1,
    pppoeNetwork = 3,           /**< adsl/pppoe有线网络*/
    wirelessNetwork = 11,        /**< other wireless网络*/
    wifiNetwork = 21,        /**< chinanet网络 */
    cdma1XNetwork = 31,          /**< 1x网络 */
    cdma3GNetwork = 32          /**< 3G网络*/
};

/*!
 * @brief 网络状态定义
 */
enum _ECNetState{
    stateUnconnect = 0,         /**< 未连接 */
    stateConnecting = 1,        /**< 正在连接 */
    stateConnected = 2,         /**< 已连接 */
    stateConnectFailed = 4,     /**< 已接失败 */
    stateCanceling = 5,         /**< 正在取消 */
    stateCanceled = 6,          /**< 已取消 */
    stateDisconnecting = 7,     /**< 正在断开 */
    stateDisconnected = 8       /**< 已断开 */
};

/**
	网络信息结构体定义
 */
typedef struct ECNetInfo
{
	uint32_t    cbSize; /**< 结构体大小 */
	enum _ECConnectType   type; /**< 网络连接类型 */
    enum _ECNetState state; /**< 当前状态 */
    uint64_t    bytesIn; /**< 已接收多少个字节 */
    uint64_t    bytesOut; /**< 已发送多少个字节 */
	uint64_t    packetsIn; /**< 已接收多少个数据包 */
	uint64_t    packetsOut; /**< 已发送多少个数据包 */
	uint64_t    errorsIn; /**< 接收有多少个错误 */
	uint64_t    errorsOut; /**< 发送有多少个错误 */
	time_t    time; /**< 连接时长 */
    char        ip[128]; /**< IP地址 */

}ECNetInfo, *LPECNetInfo;

/**
	网络连接协议定义，所有网络连接类需要实现此协议
 */
@protocol ECNetConn


/**
	连接网络
	@param userInfo 连接用户信息
	@returns 成功返回0，失败返回其他值
 */
- (int)doConnect:(NSDictionary*)userInfo;


/**
	取消当前操作
    @warning 只能取消连接操作，不能取消其他操作
 */
- (void)doCancel;


/**
	断开网络连接
 */
- (void)doDisconnect;


/**
	获取网络连接类型
	@returns 返回网络连接类型 
 */
- (int)getType;

/**
	获取1X信号量，信号量范围：0-5
	@returns 1X信号量
 */
- (int)getSignal;


/**
	获取网络状态
	@returns 网络状态 
 */
- (int)getState;


/**
	获取网络速率
	@returns 网络速率
 */
- (int)getRate;


/**
	获取网络信息
	@param netInfo 网络信息结构体
	@returns 成功返回0，失败返回其他值
 */
- (int)netInfo:(ECNetInfo*)netInfo;

/**
	是否支持断开操作
	@returns 支持返回YES，否则返回NO
 */
- (Boolean)isDisconnectSupport;


/**
	可选接口定义
 */
@optional



/**
	获取家庭无线列表,家庭无线才实现此方法
    @waring 仅家庭无线需要实现此接口
	@returns 无线列表,返回值需要手动释放内存
 */
- (NSArray*)netList;

/**
	物理连接WIFI,不认证,无线连接才实现此方法
	@returns 成功返回0,失败返回其他值
 */
- (int)connectWiFiByPhysics;


@end

#endif //end __ECConn__H__



