//
//  ECNetMgrCenter.h
//  ECNetMgr
//
//  Created by gdcn on 11-10-20.
//  Copyright 2011年 CDC. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "ECNetConn.h"


@interface ECNetMgrCenter : NSObject {
@private
    id<ECNetConn> cdma1XConnect;
    id<ECNetConn> cdma3GConnect;
    id<ECNetConn> wifiConnect;
    id<ECNetConn> wirelessConnect;
    id<ECNetConn> pppoeConnect;
    id<ECNetConn> curConnect;
    /**
    	其他网络连接对象
     */
    id<ECNetConn> otherConnect;

    
    enum _ECNetState netState;
}

@property (assign) id<ECNetConn> curConnect;

+ (id)defaultCenter;

/**
	开始网络监听
	@returns 启动成功返回YES,失败返回NO
 */
- (Boolean)startNetMonitor;


/**
	停止网络监听
 */
- (void)stopNetMonitor;


/**
	执行检测网络
 */
- (void)doNetCheck;


- (id<ECNetConn>)getCdma1XConn;
- (id<ECNetConn>)getCdma3GConn;
- (id<ECNetConn>)getWiFiConn;
- (id<ECNetConn>)getWirelessConn;
- (id<ECNetConn>)getPPPoEConn;

- (id<ECNetConn>)getCurConn;

- (enum _ECNetState)getCurState;

/**
 获取无线网卡MAC地址,无线连接才实现此方法
 @returns 成功返回当前无线网上MAC地址,否则返回nil
 */
- (NSString*)getAirPortMacAddress;

/**
	程序关闭消息调用
 */
- (void)preTerminate;

/**
	获取其他网络对象
	@returns 其他网络对象
 */
- (id<ECNetConn>)getOtherConn;


@end
