//
//  ECWiFiAccountHelper.h
//  ECNetMgr
//
//  Created by gdcn on 11-12-24.
//  Copyright 2011年 CDC. All rights reserved.
//

#import <Foundation/Foundation.h>


@class ECHttpData,ECRedirectUrl;

/**
	wifi帐号辅助处理类
    辅助类有回调处理，回调方法参考格式:-(void)WiFiAccountHelperCallback:(NSDictionary*)info
    回调参数有：
    Keys
        Result:处理结果,0表示成功,其他表示失败(NSNumber)
        Description:描述(NSString)
        Value:返回值:(NSString)
 */
@interface ECWiFiAccountHelper : NSObject {

@private
    id _target;
    SEL _selector;
    
    ECHttpData* _httpDataGetWiFiPassword1;
    ECHttpData* _httpDataGetWiFiPassword2;
    ECHttpData* _httpDataGetWiFiAccount;
    
    NSString* _account;
    Boolean   isCanceled;

    
    NSThread* _threadGetWiFiPassword;
    
    ECRedirectUrl*  _redirectUrl1;
    ECRedirectUrl*  _redirectUrl2;
    NSRunLoop*      _runLoopRef;
}

@property (retain) ECHttpData* _httpDataGetWiFiPassword1;
@property (retain) ECHttpData* _httpDataGetWiFiPassword2;
@property (retain) id _target;
@property (retain) NSRunLoop* _runLoopRef;

/**
 删除wifi帐号
 @param account 账号名
 @returns 成功返回YES，失败返回NO
 */
+ (Boolean)DeleteWiFiAccount:(NSString*)account;

/**
	初始化帐号辅助处理对象
	@param target 回调目标对象
	@param selector 回调方法;
	@returns 成功返回对象,失败返回nil
 */
- (id)initWithTarget:(id)target selector:(SEL)selector;


/**
	设置回调相关信息
	@param target 回调对象
	@param selector 回调方法
 */
-(void)setTarget:(id)target selector:(SEL)selector;

/**
	获取WIFI帐号密码
	@param account wifi帐号
	@returns 调用成功返回YES,失败返回NO,具体的成功与否通过回调响应
 */
- (Boolean)getPasswordWithAccount:(NSString*)account;


/**
	使用上网卡IMSI获取WiFi帐号
	@param imsi 上网卡imsi
	@returns 调用成功返回YES,失败返回NO,具体的成功与否通过回调响应
 */
- (Boolean)getAccountWithIMSI:(NSString*)imsi;

/**
	取消操作
 */
- (void)cancel;


@end
