//
//  ECUimMgr.h
//  ECUimMgr
//
//  Created by Alcohol on 11-11-29.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <ECCdmaMgr/ECCdmaDef.h>

#define _NM_GET_UIM_MESSAGE_ @"_NM_GET_UIM_MESSAGE_"
#define _NM_RETURN_UIM_MESSAGE_ @"_NM_RETURN_UIM_MESSAGE_"
#define _NM_DELETE_UIM_MESSAGE_ @"_NM_DELETE_UIM_MESSAGE_"
#define _NM_DELETE_SUCCESS_ @"_NM_DELETE_SUCCESS_"
#define _NM_DELETE_FAILE_ @"_NM_DELETE_FAILE_"

@class DlgPinVerify;
@class DlgEnablePinProtect;
@class DlgDisablePinProtect;
@class DlgPinModify;
@class DlgUnlockPinWithPuk;
@class DlgAccountInfoMessage;
@class DlgUimAccountAlert;

@interface ECUimMgr : NSObject {
	
	DlgPinVerify *pinVerifyController;
	DlgEnablePinProtect *enablePinProtectController;
	DlgDisablePinProtect *disablePinProtectController;
	DlgPinModify *pinModifyController;
    DlgUnlockPinWithPuk *unlockPinController;
	DlgAccountInfoMessage *accountInfoMessageController;
	DlgUimAccountAlert *uimAccountAlertController;
	
	NSMutableDictionary *messageSet;
}


/**
 获取默认管理实例。
 成功返回UIM模块管理对象，失败返回nil。 
 */
+(id)defaultUimMgr;

/**
	pin码验证接口。调用pin验证界面。
 */
-(NSInteger)verifyPinCode;


/**
	设置pin码保护接口。调用pin保护界面。 
 */
-(NSInteger)enablePinProtect;


/**
	禁用pin码保护接口。调用禁用pin保护界面。
 */
-(NSInteger)disablePinProtect;


/**
	pin码修改接口。调用pin修改界面。 
 */
-(NSInteger)modifyPinCode;


/**
	pin码解锁接口。调用pin码解锁界面。 
 */
-(NSInteger)unlockPinCode;



/**
	验证接口
	@returns CT_PIN_UNKNOW      未知
             CT_PIN_NONE_UIM    没有插卡，或者卡没有插好
             CT_PIN_READY UIM   卡没有开启PIN 码
             CT_PIN_PIN         UIM 卡有PIN 码保护，需要输入PIN 码来解锁
             CT_PIN_PUK         UIM 卡有PIN 码保护，并且输入不正确，PIN 码次数已经超过3 次，PIN 码已经被，锁定，需要输入 8 位的PUK 码来解锁
			 CT_PIN_LOCK        UIM 卡已经被永久锁定
 */
-(CT_STATE_PIN)autoDetectVerifyState;


/**
	上网卡套餐查询短信发送接口
 */
-(void)sendAccountInfoMessage;


/**
	响应读取UIM卡信息的消息。
	信息以字典形式，通过消息_NM_RETURN_UIM_MESSAGE_的userinfo发送出去。
 */
-(void)getUimMessage:(NSNotification *)notification;



/**
	响应删除UIM卡信息的消息。
	删除成功则将_NM_DELETE_SUCCESS_消息post出，失败则将_NM_DELETE_FAILE_消息post出。
 */
-(void)deleteUimMessage:(NSNotification *)notification;

/**
	PIN请求通知
	@param notification 通知参数
 */
- (void)pinReqeuestNotification:(NSNotification*)notification;


@end
