//
//  ECHttpData.h
//  ECWebInterfaceMgr
//
//  Created by gdcn on 11-12-13.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#define _METHOD_GET @"GET"
#define _METHOD_POST @"POST"

@interface ECHttpData : NSObject {
@private
    NSString*   url;
    NSString*   header;
    NSString*   body;
    NSString*   method;
    NSData*     response;
    Boolean     result;
    NSInteger   stateCode;
    NSTimeInterval timeOut;
    
    NSCondition*    condition;
    
    id          _target;
    SEL         _selector;
}

@property (retain) NSString*    url;
@property (retain) NSString*    header;
@property (retain) NSString*    body;
@property (retain) NSString*    method;
@property (retain) NSData*      response;
@property (assign) NSInteger    stateCode;
@property (assign) Boolean      result;
/**
	http访问超时设置，默认30秒
 */
@property (assign) NSTimeInterval timeOut;


/**
    初始化Http访问对象
    @param target 回调对象
    @param selector 回调方法,方法参考定义:- (void)onHttpResult:(ECHttpData*)httpData;
    @return 成功返回对象,失败返回nil
 */
- (id)initWithTarget:(id)target selector:(SEL)selector;

/**
	等待有结果才返回
	@returns 等待成功返回YES,超时返回返回NO
 */
- (Boolean)waitForResponse;


/**
	触发事件(如果有等待)
 */
- (void)signal;


/**
	重置接收事件,重置后Http返回不再调用回调接口
 */
- (void)resetRecv;


@end
