//
//  ECWebInterfaceCenter.h
//  ECWebInterfaceMgr
//
//  Created by gdcn on 11-12-13.
//  Copyright 2011年 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "ECHttpData.h"

#define _EC_MARKETINGDATA_URL	@"MarketingDataUrl"
#define	_EC_STATISTICS_URL		@"StatisticsUrl"
#define _EC_OFFICIAL_URL		@"OfficialUrl"




@interface ECWebInterfaceCenter : NSObject {
@private
    NSDictionary* webUrlDictionary;
}

/**
	默认后台交互接口管理中心
	@returns 管理对象
 */
+ (id)defaultCenter;

/**
	停止所有的Http访问
 */
- (void)stopAllHttpAccess;


/**
	发起一个Http访问请求
	@param httpData 访问相关数据
	@returns 成功发起返回YES,否则返回NO
 */
- (Boolean)httpAccessWithHttpData:(ECHttpData*)httpData;

/**
	向后台提交统计信息
    @param url 统计接口地址
	@param account 帐号
	@param statType 统计类型
	@param xml 提交的统计信息XML格式
	@param clientID 客户标志
	@returns 成功返回YES,失败返回NO
 */
- (Boolean)postStatisticsWithUrl:(NSString*)url account:(NSString*)account statType:(NSString*)statType statistics:(NSString*)xml clientID:(NSString*)clientID;


/**
	根据名字获取后台接口地址
	@param name 接口名字
	@returns 接口URLfbfh
 */
- (NSString*)getUrlByName:(NSString*)name;


/**
	增加应用点击数据
	@param appName 应用名称
	@returns 成功返回YES,失败返回NO
 */
- (Boolean)incrementAppClick:(NSString*)appName;


@end





