/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.config.gui.component;

import com.zeroturnaround.config.gui.GUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class FooterPane
extends JPanel {
    private JButton nextButton;
    private JButton backButton;
    private JButton cancelButton;

    public FooterPane(int width) {
        this.setLayout(new BoxLayout(this, 3));
        this.setMaximumSize(new Dimension(width, 40));
        this.add(new JSeparator());
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(new EmptyBorder(4, 4, 4, 4));
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        this.backButton = new JButton("< Back");
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.handleBack();
            }
        });
        this.backButton.setEnabled(false);
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUI.handleNext();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        buttonPane.add(this.cancelButton);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.backButton);
        buttonPane.add(this.nextButton);
        this.add(buttonPane);
    }

    public void focus() {
        this.nextButton.requestFocusInWindow();
    }

    public void setBackEnabled(boolean enabled) {
        this.backButton.setEnabled(enabled);
    }

    public void setNextEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
    }

    public void setFinish(boolean finish) {
        Dimension saveSize = this.nextButton.getPreferredSize();
        this.nextButton.setText(finish ? "Finish" : "Next >");
        this.nextButton.setPreferredSize(saveSize);
    }
}

