/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.config.gui.component;

import com.zeroturnaround.config.gui.GUI;
import com.zeroturnaround.config.gui.validate.LicenseValidator;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Calendar;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.zeroturnaround.javarebel.Licensing;

public class LicenseCheckPane
extends JPanel {
    private final JLabel statusLabel;
    private final JLabel errorLabel;

    public LicenseCheckPane() {
        this.setLayout(new GridBagLayout());
        JPanel centerHolder = new JPanel();
        centerHolder.setLayout(new BoxLayout(centerHolder, 3));
        centerHolder.setAlignmentX(0.5f);
        this.statusLabel = new JLabel();
        Font font = new Font(this.statusLabel.getFont().getName(), 0, this.statusLabel.getFont().getSize() + 2);
        this.statusLabel.setFont(font);
        this.errorLabel = new JLabel();
        this.errorLabel.setFont(font);
        centerHolder.add(this.statusLabel);
        centerHolder.add(this.errorLabel);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)centerHolder, c);
    }

    public void checkLicense(final LicenseValidator validator) {
        GUI.getFooter().setNextEnabled(false);
        this.errorLabel.setText("");
        this.statusLabel.setText("<html>Checking license, please wait...</html>");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    validator.validateLicense();
                    LicenseCheckPane.this.statusLabel.setText("<html>JRebel has been <b>successfully activated</b>, thank you!");
                    GUI.getFooter().setNextEnabled(true);
                    GUI.checkValid = false;
                }
                catch (Licensing.ActivationException e) {
                    LicenseCheckPane.this.statusLabel.setText("<html>Unfortunately the activation <b>failed</b>.<br/><br/></html>");
                    switch (e.getFaultCode()) {
                        case 7: {
                            LicenseCheckPane.this.errorLabel.setText("<html>The license token had an incorrect format.</html>");
                            break;
                        }
                        case 3: {
                            if (5 == e.getLicenseInfo().getLicenseType() && e.getLicenseInfo().getValidUntil().before(Calendar.getInstance())) {
                                LicenseCheckPane.this.errorLabel.setText("<html>You have already used up your 14-day JRebel trial period.<br/>To extend the period, please contact sales@zeroturnaround.com</html>");
                                break;
                            }
                            if (e.getLicenseInfo() != null && e.getLicenseInfo().getValidUntil() != null && Calendar.getInstance().after(e.getLicenseInfo().getValidUntil())) {
                                LicenseCheckPane.this.errorLabel.setText("<html>The license has expired.</html>");
                                break;
                            }
                            LicenseCheckPane.this.errorLabel.setText("<html>The license was invalid.</html>");
                            break;
                        }
                        case 2: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unable to write the license to home directory. Make sure directory is writeable.</html>");
                            break;
                        }
                        case 5: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unable to connect to License Server.</html>");
                            break;
                        }
                        case 8: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unable to connect to myJRebel.</html>");
                            break;
                        }
                        case 4: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unable to write the JRebel properties file to home directory. Make sure directory is writeable.</html>");
                            break;
                        }
                        case 1: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unable to create a temporary file.</html>");
                            break;
                        }
                        case 10: {
                            LicenseCheckPane.this.errorLabel.setText("<html>You have exceeded the amount of available myJRebel tokens, possibly due to using your subscription on too many computers.</html>");
                            break;
                        }
                        default: {
                            LicenseCheckPane.this.errorLabel.setText("<html>Unknown error, please contact support, error code: " + e.getFaultCode() + "</html>");
                        }
                    }
                }
            }
        }).start();
    }
}

