/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.config.gui.component;

import com.zeroturnaround.config.gui.GUI;
import com.zeroturnaround.config.licensing.LoggableLicensing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.zeroturnaround.javarebel.Licensing;

public class LicenseSelectionPane
extends JPanel {
    private GUI.NavState selectedNavState;
    private JLabel licenseStatus;

    public LicenseSelectionPane() {
        this.setLayout(new BoxLayout(this, 3));
        JLabel label = new JLabel("<html>The JRebel Activation Wizard will help you add a license to your JRebel installation.<br/><br/><br/></html>");
        this.licenseStatus = new JLabel("");
        this.startLicenseCheck();
        JLabel selectLabel = new JLabel("<html>Please select the type of license you would like to add:<br/><br/></html>");
        JRadioButton licenseFile = new JRadioButton("<html>License file (.lic)</html>");
        licenseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseSelectionPane.this.selectedNavState = GUI.NavState.FROMFILE;
            }
        });
        JRadioButton licenseUrl = new JRadioButton("<html>License server URL</html>");
        licenseUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseSelectionPane.this.selectedNavState = GUI.NavState.FROMLS2URL;
            }
        });
        JRadioButton myJRebel = new JRadioButton("<html>myJRebel license</html>");
        myJRebel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseSelectionPane.this.selectedNavState = GUI.NavState.FROMMYJREBEL;
            }
        });
        JRadioButton evaluation = new JRadioButton("<html>New 14-day trial</html>");
        evaluation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LicenseSelectionPane.this.selectedNavState = GUI.NavState.FROMEVAL;
            }
        });
        ButtonGroup buttons = new ButtonGroup();
        buttons.add(licenseFile);
        buttons.add(licenseUrl);
        buttons.add(myJRebel);
        buttons.add(evaluation);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.setBorder(new EmptyBorder(0, 64, 16, 0));
        buttonPanel.add(licenseFile);
        buttonPanel.add(licenseUrl);
        buttonPanel.add(myJRebel);
        buttonPanel.add(evaluation);
        this.add(label);
        this.add(this.licenseStatus);
        this.add(selectLabel);
        this.add(buttonPanel);
        this.add(Box.createVerticalStrut(16));
    }

    public void startLicenseCheck() {
        this.licenseStatus.setText("<html>Checking JRebel license status...<br/><br/><br/></html>");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Licensing.SDKLicenseInfo currentLicense = LoggableLicensing.getCurrentLicense();
                    switch (currentLicense.getLicenseType()) {
                        case 5: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You have a valid <b>Evaluation License</b>.<br/><br/><br/></html>");
                            break;
                        }
                        case 4: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You have a valid <b>Base License</b>.<br/><br/><br/></html>");
                            break;
                        }
                        case 2: 
                        case 3: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You have a valid <b>Enterprise License</b>.<br/><br/><br/></html>");
                            break;
                        }
                        case 1: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You have a valid <b>myJRebel license</b>.<br/><br/><br/></html>");
                            break;
                        }
                        case 0: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You currently do not have any licenses added.<br/><br/><br/></html>");
                            break;
                        }
                        default: {
                            LicenseSelectionPane.this.licenseStatus.setText("<html>You have a <b>valid license</b>.<br/><br/><br/></html>");
                            break;
                        }
                    }
                }
                catch (Licensing.ExpiredLicenseException e) {
                    LicenseSelectionPane.this.licenseStatus.setText("<html>Your license <b>has expired</b>!<br/><br/><br/></html>");
                }
            }
        }).start();
    }

    public GUI.NavState getSelectedNavState() {
        return this.selectedNavState;
    }
}

