/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticsInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<DiagnosticsInfo> children = new ArrayList<DiagnosticsInfo>();
    private final List<String> values = new ArrayList<String>();

    public DiagnosticsInfo(String id) {
        this.id = id;
    }

    public DiagnosticsInfo(String id, String value) {
        this(id);
        this.addValue(value);
    }

    public DiagnosticsInfo(String id, Number value) {
        this(id);
        this.addValue(String.valueOf(value));
    }

    public DiagnosticsInfo(String id, int value) {
        this(id);
        this.addValue(String.valueOf(value));
    }

    public DiagnosticsInfo(String id, long value) {
        this(id);
        this.addValue(Long.toString(value));
    }

    public DiagnosticsInfo(String id, double value) {
        this(id);
        this.addValue(String.valueOf(value));
    }

    public DiagnosticsInfo(String id, Collection<DiagnosticsInfo> children) {
        this(id);
        this.getChildren().addAll(children);
    }

    public DiagnosticsInfo(String id, DiagnosticsInfo childElement) {
        this(id);
        this.getChildren().add(childElement);
    }

    public String getId() {
        return this.id;
    }

    public String getValue() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public List<DiagnosticsInfo> getChildren() {
        return this.children;
    }

    public void addChild(DiagnosticsInfo o) {
        if (o != null) {
            this.children.add(o);
        }
    }

    public void addChildren(List<DiagnosticsInfo> o) {
        if (o != null) {
            this.children.addAll(o);
        }
    }

    public DiagnosticsInfo getChild(String id) {
        for (DiagnosticsInfo info : this.children) {
            if (!info.id.equals(id)) continue;
            return info;
        }
        return null;
    }

    public String toString() {
        Iterator<Object> it;
        boolean first;
        StringBuilder sb = new StringBuilder("{").append(this.id);
        if (this.getValues().size() > 0) {
            first = true;
            sb.append(", ").append(" values = [");
            it = this.getValues().iterator();
            while (it.hasNext()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append((String)it.next());
                first = false;
            }
            sb.append("]");
        }
        if (this.getChildren().size() > 0) {
            first = true;
            sb.append(",").append(" children = [");
            it = this.getChildren().iterator();
            while (it.hasNext()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append("(");
                sb.append(it.next());
                sb.append(")");
                first = false;
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

