/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.javarebel.DiagnosticsInfo;
import org.zeroturnaround.javarebel.DiagnosticsInfoManager;
import org.zeroturnaround.javarebel.DiagnosticsInfoManagerFactory;
import org.zeroturnaround.javarebel.DiagnosticsInfoProvider;
import org.zeroturnaround.javarebel.RequestData;
import org.zeroturnaround.javarebel.RequestInfoManagerFactory;
import org.zeroturnaround.javarebel.SQLQueryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLDiagnosticsInfoProvider
implements DiagnosticsInfoProvider {
    public static final String ID = "SqlQueries";
    static DiagnosticsInfoManager manager = DiagnosticsInfoManagerFactory.getInstance();
    static final SQLDiagnosticsInfoProvider provider = new SQLDiagnosticsInfoProvider();
    private final List<SQLQueryInfo> queries = new ArrayList<SQLQueryInfo>();

    public static void init() {
        if (manager.getProvider(ID, provider.getClass().getClassLoader()) == null) {
            throw new IllegalStateException("Failed to init and register SQLDiagnosticsInfoProvider");
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiagnosticsInfo getDiagnosticsInfo(String[] params) {
        String requestId = params[1];
        DiagnosticsInfo answer = new DiagnosticsInfo(ID);
        for (SQLQueryInfo q : this.queries) {
            if (!requestId.equals(q.requestId)) continue;
            SQLQueryInfo sQLQueryInfo = q;
            synchronized (sQLQueryInfo) {
                DiagnosticsInfo query = new DiagnosticsInfo("query");
                query.addChild(new DiagnosticsInfo("id", q.getId()));
                query.addChild(new DiagnosticsInfo("timestamp", q.timestamp));
                query.addChild(new DiagnosticsInfo("requestId", q.requestId));
                query.addChild(new DiagnosticsInfo("rawSql", q.rawSql));
                query.addChild(new DiagnosticsInfo("sql", q.sql));
                query.addChild(new DiagnosticsInfo("duration", q.duration));
                query.addChild(new DiagnosticsInfo("stackTrace", this.getStackTrace(q.stackTrace)));
                query.addChild(new DiagnosticsInfo("statementId", q.statementId));
                query.addChild(new DiagnosticsInfo("driverName", q.driverName));
                query.addChild(new DiagnosticsInfo("dataAccessFramework", q.dataAccess));
                query.addChild(new DiagnosticsInfo("processingTime", q.processingTime));
                query.addChild(new DiagnosticsInfo("numRowsProcessed", q.numRowsProcessed));
                answer.addChild(query);
            }
        }
        return answer;
    }

    private List<DiagnosticsInfo> getStackTrace(StackTraceElement[] stack) {
        ArrayList<DiagnosticsInfo> result = new ArrayList<DiagnosticsInfo>();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement e = stack[i];
            DiagnosticsInfo ex = new DiagnosticsInfo("stack");
            String className = e.getClassName();
            String fileName = e.getFileName();
            if (i == 0) {
                if (className.contains("_$$_")) {
                    className = className.substring(0, className.indexOf("_$$_"));
                }
                if (fileName.contains("_$$_")) {
                    int pos1 = fileName.indexOf("_$$_");
                    int pos2 = fileName.lastIndexOf(".java");
                    fileName = fileName.substring(0, pos1) + fileName.substring(pos2);
                }
            }
            ex.addChild(new DiagnosticsInfo("class", className));
            ex.addChild(new DiagnosticsInfo("method", e.getMethodName()));
            ex.addChild(new DiagnosticsInfo("line", Integer.toString(e.getLineNumber())));
            ex.addChild(new DiagnosticsInfo("file", fileName));
            result.add(ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLQueryInfo registerSqlQuery(Object statement, String rawSql, String sql, long timestamp, long duration, String driverName, String dataAccess) {
        SQLDiagnosticsInfoProvider sQLDiagnosticsInfoProvider = provider;
        synchronized (sQLDiagnosticsInfoProvider) {
            RequestData req = RequestInfoManagerFactory.getInstance().getCurrentRequest();
            String requestId = req != null ? req.getId() : null;
            SQLQueryInfo info = new SQLQueryInfo(requestId, statement, rawSql, sql, timestamp, duration, Thread.currentThread().getStackTrace(), driverName, dataAccess);
            SQLDiagnosticsInfoProvider.provider.queries.add(info);
            if (SQLDiagnosticsInfoProvider.provider.queries.size() > 200) {
                SQLDiagnosticsInfoProvider.provider.queries.remove(0);
            }
            return info;
        }
    }

    private static String getId(Object o) {
        return Integer.toHexString(System.identityHashCode(o));
    }

    static {
        manager.addDiagnosticsInfoProvider(provider);
    }
}

