/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Choice;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Set;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DLTaggedObject;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    int a;
    boolean a;
    boolean b = true;
    ASN1Encodable a = null;

    public static ASN1TaggedObject getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        if (bl2) {
            return (ASN1TaggedObject)aSN1TaggedObject.getObject();
        }
        throw new IllegalArgumentException("implicitly tagged tagged object");
    }

    public static ASN1TaggedObject getInstance(Object object) {
        if (object == null || object instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)object;
        }
        if (object instanceof byte[]) {
            try {
                return ASN1TaggedObject.getInstance(ASN1TaggedObject.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct tagged object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    public ASN1TaggedObject(boolean bl2, int n2, ASN1Encodable aSN1Encodable) {
        this.b = aSN1Encodable instanceof ASN1Choice ? true : bl2;
        this.a = n2;
        if (this.b) {
            this.a = aSN1Encodable;
        } else {
            ASN1Primitive aSN1Primitive = aSN1Encodable.toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Set) {
                Object var5_5 = null;
            }
            this.a = aSN1Encodable;
        }
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            return false;
        }
        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
        if (this.a != aSN1TaggedObject.a || this.a != aSN1TaggedObject.a || this.b != aSN1TaggedObject.b) {
            return false;
        }
        return !(this.a == null ? aSN1TaggedObject.a != null : !this.a.toASN1Primitive().equals(aSN1TaggedObject.a.toASN1Primitive()));
    }

    public int hashCode() {
        int n2 = this.a;
        if (this.a != null) {
            n2 ^= this.a.hashCode();
        }
        return n2;
    }

    public int getTagNo() {
        return this.a;
    }

    public boolean isExplicit() {
        return this.b;
    }

    public boolean isEmpty() {
        return this.a;
    }

    public ASN1Primitive getObject() {
        if (this.a != null) {
            return this.a.toASN1Primitive();
        }
        return null;
    }

    public ASN1Encodable getObjectParser(int n2, boolean bl2) {
        switch (n2) {
            case 17: {
                return ASN1Set.getInstance(this, bl2).parser();
            }
            case 16: {
                return ASN1Sequence.getInstance(this, bl2).parser();
            }
            case 4: {
                return ASN1OctetString.getInstance(this, bl2).parser();
            }
        }
        if (bl2) {
            return this.getObject();
        }
        throw new RuntimeException("implicit tagging not implemented for tag: " + n2);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    ASN1Primitive a() {
        return new DERTaggedObject(this.b, this.a, this.a);
    }

    ASN1Primitive b() {
        return new DLTaggedObject(this.b, this.a, this.a);
    }

    public String toString() {
        return "[" + this.a + "]" + this.a;
    }
}

