/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Encodable;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.BEROctetString$1;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DEROctetString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class BEROctetString
extends ASN1OctetString {
    private static final int MAX_LENGTH = 1000;
    private ASN1OctetString[] octs;

    private static byte[] toBytes(ASN1OctetString[] aSN1OctetStringArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != aSN1OctetStringArray.length; ++i2) {
            try {
                DEROctetString dEROctetString = (DEROctetString)aSN1OctetStringArray[i2];
                byteArrayOutputStream.write(dEROctetString.getOctets());
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException(aSN1OctetStringArray[i2].getClass().getName() + " found in input should only contain DEROctetString");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("exception converting octets " + iOException.toString());
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public BEROctetString(byte[] byArray) {
        super(byArray);
    }

    public BEROctetString(ASN1OctetString[] aSN1OctetStringArray) {
        super(BEROctetString.toBytes(aSN1OctetStringArray));
        this.octs = aSN1OctetStringArray;
    }

    public byte[] getOctets() {
        return this.a;
    }

    public Enumeration getObjects() {
        if (this.octs == null) {
            return this.generateOcts().elements();
        }
        return new BEROctetString$1(this);
    }

    private Vector generateOcts() {
        Vector<DEROctetString> vector = new Vector<DEROctetString>();
        for (int i2 = 0; i2 < this.a.length; i2 += 1000) {
            int n2 = i2 + 1000 > this.a.length ? this.a.length : i2 + 1000;
            byte[] byArray = new byte[n2 - i2];
            System.arraycopy(this.a, i2, byArray, 0, byArray.length);
            vector.addElement(new DEROctetString(byArray));
        }
        return vector;
    }

    boolean isConstructed() {
        return true;
    }

    int a() throws IOException {
        int n2 = 0;
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            n2 += ((ASN1Encodable)enumeration.nextElement()).toASN1Primitive().a();
        }
        return 2 + n2 + 2;
    }

    public void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.write(36);
        aSN1OutputStream.write(128);
        Enumeration enumeration = this.getObjects();
        while (enumeration.hasMoreElements()) {
            aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    static BEROctetString a(ASN1Sequence aSN1Sequence) {
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1Sequence.size()];
        Enumeration enumeration = aSN1Sequence.getObjects();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            aSN1OctetStringArray[n2++] = (ASN1OctetString)enumeration.nextElement();
        }
        return new BEROctetString(aSN1OctetStringArray);
    }

    static ASN1OctetString[] a(BEROctetString bEROctetString) {
        return bEROctetString.octs;
    }
}

