/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OctetString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1OutputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.StreamUtil;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class DERInteger
extends ASN1Primitive {
    byte[] a;

    public static ASN1Integer getInstance(Object object) {
        if (object == null || object instanceof ASN1Integer) {
            return (ASN1Integer)object;
        }
        if (object instanceof DERInteger) {
            return new ASN1Integer(((DERInteger)object).getValue());
        }
        if (object instanceof byte[]) {
            try {
                return (ASN1Integer)DERInteger.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERInteger) {
            return DERInteger.getInstance(aSN1Primitive);
        }
        return new ASN1Integer(ASN1OctetString.getInstance(aSN1TaggedObject.getObject()).getOctets());
    }

    public DERInteger(long l2) {
        this.a = BigInteger.valueOf(l2).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.a = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.a = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.a);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.a);
    }

    boolean isConstructed() {
        return false;
    }

    int a() {
        return 1 + StreamUtil.a(this.a.length) + this.a.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.a(2, this.a);
    }

    public int hashCode() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            n2 ^= (this.a[i2] & 0xFF) << i2 % 4;
        }
        return n2;
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)aSN1Primitive;
        return Arrays.areEqual(this.a, dERInteger.a);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

