/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.eac;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1InputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERApplicationSpecific;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.eac.BidirectionalMap;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.eac.EACObjectIdentifiers;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.eac.EACTags;
import com.zeroturnaround.bundled.org.bouncycastle.util.Integers;
import java.io.IOException;
import java.util.Hashtable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CertificateHolderAuthorization
extends ASN1Object {
    ASN1ObjectIdentifier a;
    DERApplicationSpecific a;
    public static final ASN1ObjectIdentifier id_role_EAC = EACObjectIdentifiers.bsi_de.branch("3.1.2.1");
    public static final int CVCA = 192;
    public static final int DV_DOMESTIC = 128;
    public static final int DV_FOREIGN = 64;
    public static final int IS = 0;
    public static final int RADG4 = 2;
    public static final int RADG3 = 1;
    static Hashtable a = new Hashtable();
    static BidirectionalMap a = new BidirectionalMap();
    static Hashtable b = new Hashtable();

    public static String GetRoleDescription(int n2) {
        return (String)a.get(Integers.valueOf(n2));
    }

    public static int GetFlag(String string) {
        Integer n2 = (Integer)a.getReverse(string);
        if (n2 == null) {
            throw new IllegalArgumentException("Unknown value " + string);
        }
        return n2;
    }

    private void setPrivateData(ASN1InputStream aSN1InputStream) throws IOException {
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            throw new IllegalArgumentException("no Oid in CerticateHolderAuthorization");
        }
        this.a = (ASN1ObjectIdentifier)aSN1Primitive;
        aSN1Primitive = aSN1InputStream.readObject();
        if (!(aSN1Primitive instanceof DERApplicationSpecific)) {
            throw new IllegalArgumentException("No access rights in CerticateHolderAuthorization");
        }
        this.a = (DERApplicationSpecific)aSN1Primitive;
    }

    public CertificateHolderAuthorization(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) throws IOException {
        this.setOid(aSN1ObjectIdentifier);
        this.setAccessRights((byte)n2);
    }

    public CertificateHolderAuthorization(DERApplicationSpecific dERApplicationSpecific) throws IOException {
        if (dERApplicationSpecific.getApplicationTag() == 76) {
            this.setPrivateData(new ASN1InputStream(dERApplicationSpecific.getContents()));
        }
    }

    public int getAccessRights() {
        return this.a.getContents()[0] & 0xFF;
    }

    private void setAccessRights(byte by2) {
        byte[] byArray = new byte[]{by2};
        this.a = new DERApplicationSpecific(EACTags.getTag(83), byArray);
    }

    public ASN1ObjectIdentifier getOid() {
        return this.a;
    }

    private void setOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.a = aSN1ObjectIdentifier;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        return new DERApplicationSpecific(76, aSN1EncodableVector);
    }

    static {
        a.put(Integers.valueOf(2), "RADG4");
        a.put(Integers.valueOf(1), "RADG3");
        a.put(Integers.valueOf(192), "CVCA");
        a.put(Integers.valueOf(128), "DV_DOMESTIC");
        a.put(Integers.valueOf(64), "DV_FOREIGN");
        a.put(Integers.valueOf(0), "IS");
    }
}

