/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.ess;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ess.ESSCertIDv2;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.PolicyInformation;

public class SigningCertificateV2
extends ASN1Object {
    ASN1Sequence a;
    ASN1Sequence b;

    public static SigningCertificateV2 getInstance(Object object) {
        if (object == null || object instanceof SigningCertificateV2) {
            return (SigningCertificateV2)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SigningCertificateV2((ASN1Sequence)object);
        }
        return null;
    }

    private SigningCertificateV2(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.a = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public SigningCertificateV2(ESSCertIDv2 eSSCertIDv2) {
        this.a = new DERSequence(eSSCertIDv2);
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int i2 = 0; i2 < eSSCertIDv2Array.length; ++i2) {
            aSN1EncodableVector.add(eSSCertIDv2Array[i2]);
        }
        this.a = new DERSequence(aSN1EncodableVector);
    }

    public SigningCertificateV2(ESSCertIDv2[] eSSCertIDv2Array, PolicyInformation[] policyInformationArray) {
        int n2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (n2 = 0; n2 < eSSCertIDv2Array.length; ++n2) {
            aSN1EncodableVector.add(eSSCertIDv2Array[n2]);
        }
        this.a = new DERSequence(aSN1EncodableVector);
        if (policyInformationArray != null) {
            aSN1EncodableVector = new ASN1EncodableVector();
            for (n2 = 0; n2 < policyInformationArray.length; ++n2) {
                aSN1EncodableVector.add(policyInformationArray[n2]);
            }
            this.b = new DERSequence(aSN1EncodableVector);
        }
    }

    public ESSCertIDv2[] getCerts() {
        ESSCertIDv2[] eSSCertIDv2Array = new ESSCertIDv2[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            eSSCertIDv2Array[i2] = ESSCertIDv2.getInstance(this.a.getObjectAt(i2));
        }
        return eSSCertIDv2Array;
    }

    public PolicyInformation[] getPolicies() {
        if (this.b == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.b.size()];
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance(this.b.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

