/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.ResponseBytes;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OCSPResponse
extends ASN1Object {
    OCSPResponseStatus a;
    ResponseBytes a;

    public OCSPResponse(OCSPResponseStatus oCSPResponseStatus, ResponseBytes responseBytes) {
        this.a = oCSPResponseStatus;
        this.a = responseBytes;
    }

    private OCSPResponse(ASN1Sequence aSN1Sequence) {
        this.a = OCSPResponseStatus.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() == 2) {
            this.a = ResponseBytes.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public static OCSPResponse getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return OCSPResponse.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static OCSPResponse getInstance(Object object) {
        if (object instanceof OCSPResponse) {
            return (OCSPResponse)object;
        }
        if (object != null) {
            return new OCSPResponse(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public OCSPResponseStatus getResponseStatus() {
        return this.a;
    }

    public ResponseBytes getResponseBytes() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

