/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp.CertID;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extensions;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Request
extends ASN1Object {
    CertID a;
    Extensions a;

    public Request(CertID certID, Extensions extensions) {
        this.a = certID;
        this.a = extensions;
    }

    private Request(ASN1Sequence aSN1Sequence) {
        this.a = CertID.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() == 2) {
            this.a = Extensions.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public static Request getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Request.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static Request getInstance(Object object) {
        if (object instanceof Request) {
            return (Request)object;
        }
        if (object != null) {
            return new Request(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertID getReqCert() {
        return this.a;
    }

    public Extensions getSingleRequestExtensions() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

