/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.ocsp;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBitString;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Signature
extends ASN1Object {
    AlgorithmIdentifier a;
    DERBitString a;
    ASN1Sequence a;

    public Signature(AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString) {
        this.a = algorithmIdentifier;
        this.a = dERBitString;
    }

    public Signature(AlgorithmIdentifier algorithmIdentifier, DERBitString dERBitString, ASN1Sequence aSN1Sequence) {
        this.a = algorithmIdentifier;
        this.a = dERBitString;
        this.a = aSN1Sequence;
    }

    private Signature(ASN1Sequence aSN1Sequence) {
        this.a = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
        this.a = (DERBitString)aSN1Sequence.getObjectAt(1);
        if (aSN1Sequence.size() == 3) {
            this.a = ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(2), true);
        }
    }

    public static Signature getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Signature.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static Signature getInstance(Object object) {
        if (object instanceof Signature) {
            return (Signature)object;
        }
        if (object != null) {
            return new Signature(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public DERBitString getSignature() {
        return this.a;
    }

    public ASN1Sequence getCerts() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

