/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.pkcs;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Set;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERTaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x500.X500Name;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Name;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CertificationRequestInfo
extends ASN1Object {
    ASN1Integer a;
    X500Name a;
    SubjectPublicKeyInfo a;
    ASN1Set a = null;

    public static CertificationRequestInfo getInstance(Object object) {
        if (object instanceof CertificationRequestInfo) {
            return (CertificationRequestInfo)object;
        }
        if (object != null) {
            return new CertificationRequestInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertificationRequestInfo(X500Name x500Name, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1Set aSN1Set) {
        this.a = x500Name;
        this.a = subjectPublicKeyInfo;
        this.a = aSN1Set;
        if (x500Name == null || this.a == null || this.a == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public CertificationRequestInfo(X509Name x509Name, SubjectPublicKeyInfo subjectPublicKeyInfo, ASN1Set aSN1Set) {
        this.a = X500Name.getInstance(x509Name.toASN1Primitive());
        this.a = subjectPublicKeyInfo;
        this.a = aSN1Set;
        if (x509Name == null || this.a == null || this.a == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public CertificationRequestInfo(ASN1Sequence aSN1Sequence) {
        this.a = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        this.a = X500Name.getInstance(aSN1Sequence.getObjectAt(1));
        this.a = SubjectPublicKeyInfo.getInstance(aSN1Sequence.getObjectAt(2));
        if (aSN1Sequence.size() > 3) {
            DERTaggedObject dERTaggedObject = (DERTaggedObject)aSN1Sequence.getObjectAt(3);
            this.a = ASN1Set.getInstance(dERTaggedObject, false);
        }
        if (this.a == null || this.a == null || this.a == null) {
            throw new IllegalArgumentException("Not all mandatory fields set in CertificationRequestInfo generator.");
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public X500Name getSubject() {
        return this.a;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.a;
    }

    public ASN1Set getAttributes() {
        return this.a;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.a);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.a));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

