/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Boolean;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1EncodableVector;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Integer;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Sequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERBoolean;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERSequence;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extension;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Extensions;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.X509Extension;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BasicConstraints
extends ASN1Object {
    ASN1Boolean a;
    ASN1Integer a = null;

    public static BasicConstraints getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return BasicConstraints.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static BasicConstraints getInstance(Object object) {
        if (object instanceof BasicConstraints) {
            return (BasicConstraints)object;
        }
        if (object instanceof X509Extension) {
            return BasicConstraints.getInstance(X509Extension.convertValueToObject((X509Extension)object));
        }
        if (object != null) {
            return new BasicConstraints(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static BasicConstraints fromExtensions(Extensions extensions) {
        return BasicConstraints.getInstance(extensions.getExtensionParsedValue(Extension.basicConstraints));
    }

    private BasicConstraints(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 0) {
            this.a = null;
            this.a = null;
        } else {
            if (aSN1Sequence.getObjectAt(0) instanceof DERBoolean) {
                this.a = DERBoolean.getInstance(aSN1Sequence.getObjectAt(0));
            } else {
                this.a = null;
                this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(0));
            }
            if (aSN1Sequence.size() > 1) {
                if (this.a != null) {
                    this.a = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
                } else {
                    throw new IllegalArgumentException("wrong sequence in constructor");
                }
            }
        }
    }

    public BasicConstraints(boolean bl2) {
        this.a = bl2 ? ASN1Boolean.getInstance(true) : null;
        this.a = null;
    }

    public BasicConstraints(int n2) {
        this.a = ASN1Boolean.getInstance(true);
        this.a = new ASN1Integer(n2);
    }

    public boolean isCA() {
        return this.a != null && this.a.isTrue();
    }

    public BigInteger getPathLenConstraint() {
        if (this.a != null) {
            return this.a.getValue();
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        if (this.a == null) {
            if (this.a == null) {
                return "BasicConstraints: isCa(false)";
            }
            return "BasicConstraints: isCa(" + this.isCA() + ")";
        }
        return "BasicConstraints: isCa(" + this.isCA() + "), pathLenConstraint = " + this.a.getValue();
    }
}

