/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.asn1.x509;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Choice;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Object;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1TaggedObject;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERGeneralizedTime;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.DERUTCTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class Time
extends ASN1Object
implements ASN1Choice {
    ASN1Primitive a;

    public static Time getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Time.getInstance(aSN1TaggedObject.getObject());
    }

    public Time(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERUTCTime) && !(aSN1Primitive instanceof DERGeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.a = aSN1Primitive;
    }

    public Time(Date date) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "Z");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        String string = simpleDateFormat.format(date) + "Z";
        int n2 = Integer.parseInt(string.substring(0, 4));
        this.a = n2 < 1950 || n2 > 2049 ? new DERGeneralizedTime(string) : new DERUTCTime(string.substring(2));
    }

    public static Time getInstance(Object object) {
        if (object == null || object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof DERUTCTime) {
            return new Time((DERUTCTime)object);
        }
        if (object instanceof DERGeneralizedTime) {
            return new Time((DERGeneralizedTime)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public String getTime() {
        if (this.a instanceof DERUTCTime) {
            return ((DERUTCTime)this.a).getAdjustedTime();
        }
        return ((DERGeneralizedTime)this.a).getTime();
    }

    public Date getDate() {
        try {
            if (this.a instanceof DERUTCTime) {
                return ((DERUTCTime)this.a).getAdjustedDate();
            }
            return ((DERGeneralizedTime)this.a).getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }

    public String toString() {
        return this.getTime();
    }
}

