/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DataLengthException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.StreamCipher;

public class StreamBlockCipher
implements StreamCipher {
    private BlockCipher cipher;
    private byte[] oneByte = new byte[1];

    public StreamBlockCipher(BlockCipher blockCipher) {
        if (blockCipher.getBlockSize() != 1) {
            throw new IllegalArgumentException("block cipher block size != 1.");
        }
        this.cipher = blockCipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.cipher.init(bl2, cipherParameters);
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    public byte returnByte(byte by2) {
        this.oneByte[0] = by2;
        this.cipher.processBlock(this.oneByte, 0, this.oneByte, 0);
        return this.oneByte[0];
    }

    public void processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        if (n4 + n3 > byArray2.length) {
            throw new DataLengthException("output buffer too small in processBytes()");
        }
        for (int i2 = 0; i2 != n3; ++i2) {
            this.cipher.processBlock(byArray, n2 + i2, byArray2, n4 + i2);
        }
    }

    public void reset() {
        this.cipher.reset();
    }
}

