/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.engines;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DataLengthException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Wrapper;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithIV;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;

public class RFC3394WrapEngine
implements Wrapper {
    private BlockCipher engine;
    private KeyParameter param;
    private boolean forWrapping;
    private byte[] iv = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};

    public RFC3394WrapEngine(BlockCipher blockCipher) {
        this.engine = blockCipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forWrapping = bl2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters = ((ParametersWithRandom)cipherParameters).getParameters();
        }
        if (cipherParameters instanceof KeyParameter) {
            this.param = (KeyParameter)cipherParameters;
        } else if (cipherParameters instanceof ParametersWithIV) {
            this.iv = ((ParametersWithIV)cipherParameters).getIV();
            this.param = (KeyParameter)((ParametersWithIV)cipherParameters).getParameters();
            if (this.iv.length != 8) {
                throw new IllegalArgumentException("IV not equal to 8");
            }
        }
    }

    public String getAlgorithmName() {
        return this.engine.getAlgorithmName();
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        if (!this.forWrapping) {
            throw new IllegalStateException("not set for wrapping");
        }
        int n4 = n3 / 8;
        if (n4 * 8 != n3) {
            throw new DataLengthException("wrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n3 + this.iv.length];
        byte[] byArray3 = new byte[8 + this.iv.length];
        System.arraycopy(this.iv, 0, byArray2, 0, this.iv.length);
        System.arraycopy(byArray, 0, byArray2, this.iv.length, n3);
        this.engine.init(true, this.param);
        for (int i2 = 0; i2 != 6; ++i2) {
            for (int i3 = 1; i3 <= n4; ++i3) {
                System.arraycopy(byArray2, 0, byArray3, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * i3, byArray3, this.iv.length, 8);
                this.engine.processBlock(byArray3, 0, byArray3, 0);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by2 = (byte)n5;
                    int n7 = this.iv.length - n6;
                    byArray3[n7] = (byte)(byArray3[n7] ^ by2);
                    n5 >>>= 8;
                    ++n6;
                }
                System.arraycopy(byArray3, 0, byArray2, 0, 8);
                System.arraycopy(byArray3, 8, byArray2, 8 * i3, 8);
            }
        }
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.forWrapping) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n4 = n3 / 8;
        if (n4 * 8 != n3) {
            throw new InvalidCipherTextException("unwrap data must be a multiple of 8 bytes");
        }
        byte[] byArray2 = new byte[n3 - this.iv.length];
        byte[] byArray3 = new byte[this.iv.length];
        byte[] byArray4 = new byte[8 + this.iv.length];
        System.arraycopy(byArray, 0, byArray3, 0, this.iv.length);
        System.arraycopy(byArray, this.iv.length, byArray2, 0, n3 - this.iv.length);
        this.engine.init(false, this.param);
        --n4;
        for (int i2 = 5; i2 >= 0; --i2) {
            for (int i3 = n4; i3 >= 1; --i3) {
                System.arraycopy(byArray3, 0, byArray4, 0, this.iv.length);
                System.arraycopy(byArray2, 8 * (i3 - 1), byArray4, this.iv.length, 8);
                int n5 = n4 * i2 + i3;
                int n6 = 1;
                while (n5 != 0) {
                    byte by2 = (byte)n5;
                    int n7 = this.iv.length - n6;
                    byArray4[n7] = (byte)(byArray4[n7] ^ by2);
                    n5 >>>= 8;
                    ++n6;
                }
                this.engine.processBlock(byArray4, 0, byArray4, 0);
                System.arraycopy(byArray4, 0, byArray3, 0, 8);
                System.arraycopy(byArray4, 8, byArray2, 8 * (i3 - 1), 8);
            }
        }
        if (!Arrays.constantTimeAreEqual(byArray3, this.iv)) {
            throw new InvalidCipherTextException("checksum failed");
        }
        return byArray2;
    }
}

