/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.generators;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DHParameters;
import com.zeroturnaround.bundled.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

class DHKeyGeneratorHelper {
    static final DHKeyGeneratorHelper a = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger a(DHParameters dHParameters, SecureRandom secureRandom) {
        BigInteger bigInteger = dHParameters.getP();
        int n2 = dHParameters.getL();
        if (n2 != 0) {
            return new BigInteger(n2, secureRandom).setBit(n2 - 1);
        }
        BigInteger bigInteger2 = TWO;
        int n3 = dHParameters.getM();
        if (n3 != 0) {
            bigInteger2 = ONE.shiftLeft(n3 - 1);
        }
        BigInteger bigInteger3 = bigInteger.subtract(TWO);
        BigInteger bigInteger4 = dHParameters.getQ();
        if (bigInteger4 != null) {
            bigInteger3 = bigInteger4.subtract(TWO);
        }
        return BigIntegers.createRandomInRange(bigInteger2, bigInteger3, secureRandom);
    }

    BigInteger a(DHParameters dHParameters, BigInteger bigInteger) {
        return dHParameters.getG().modPow(bigInteger, dHParameters.getP());
    }
}

