/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.kems;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DerivationFunction;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.KeyEncapsulation;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KDFParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.math.ec.ECPoint;
import com.zeroturnaround.bundled.org.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECIESKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private ECKeyParameters key;
    private boolean CofactorMode;
    private boolean OldCofactorMode;
    private boolean SingleHashMode;

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = false;
        this.OldCofactorMode = false;
        this.SingleHashMode = false;
    }

    public ECIESKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom, boolean bl2, boolean bl3, boolean bl4) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
        this.CofactorMode = bl2;
        this.OldCofactorMode = bl3;
        this.SingleHashMode = bl4;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof ECKeyParameters)) {
            throw new IllegalArgumentException("EC key required");
        }
        this.key = (ECKeyParameters)cipherParameters;
    }

    public CipherParameters encrypt(byte[] byArray, int n2, int n3) throws IllegalArgumentException {
        byte[] byArray2;
        if (!(this.key instanceof ECPublicKeyParameters)) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = this.key.getParameters().getH();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange(ONE, bigInteger, this.rnd);
        ECPoint eCPoint = this.key.getParameters().getG().multiply(bigInteger3);
        byte[] byArray3 = eCPoint.getEncoded();
        System.arraycopy(byArray3, 0, byArray, n2, byArray3.length);
        BigInteger bigInteger4 = this.CofactorMode ? bigInteger3.multiply(bigInteger2).mod(bigInteger) : bigInteger3;
        ECPoint eCPoint2 = ((ECPublicKeyParameters)this.key).getQ().multiply(bigInteger4);
        int n4 = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(n4, eCPoint2.getX().toBigInteger());
        if (this.SingleHashMode) {
            byArray2 = new byte[byArray3.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, byArray3.length, byArray4.length);
        } else {
            byArray2 = byArray4;
        }
        this.kdf.init(new KDFParameters(byArray2, null));
        byte[] byArray5 = new byte[n3];
        this.kdf.generateBytes(byArray5, 0, byArray5.length);
        return new KeyParameter(byArray5);
    }

    public CipherParameters encrypt(byte[] byArray, int n2) {
        return this.encrypt(byArray, 0, n2);
    }

    public CipherParameters decrypt(byte[] byArray, int n2, int n3, int n4) throws IllegalArgumentException {
        byte[] byArray2;
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("Private key required for encryption");
        }
        BigInteger bigInteger = this.key.getParameters().getN();
        BigInteger bigInteger2 = this.key.getParameters().getH();
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        ECPoint eCPoint = this.key.getParameters().getCurve().decodePoint(byArray3);
        ECPoint eCPoint2 = this.CofactorMode || this.OldCofactorMode ? eCPoint.multiply(bigInteger2) : eCPoint;
        BigInteger bigInteger3 = this.CofactorMode ? ((ECPrivateKeyParameters)this.key).getD().multiply(bigInteger2.modInverse(bigInteger)).mod(bigInteger) : ((ECPrivateKeyParameters)this.key).getD();
        ECPoint eCPoint3 = eCPoint2.multiply(bigInteger3);
        int n5 = (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
        byte[] byArray4 = BigIntegers.asUnsignedByteArray(n5, eCPoint3.getX().toBigInteger());
        if (this.SingleHashMode) {
            byArray2 = new byte[byArray3.length + byArray4.length];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            System.arraycopy(byArray4, 0, byArray2, byArray3.length, byArray4.length);
        } else {
            byArray2 = byArray4;
        }
        this.kdf.init(new KDFParameters(byArray2, null));
        byte[] byArray5 = new byte[n4];
        this.kdf.generateBytes(byArray5, 0, byArray5.length);
        return new KeyParameter(byArray5);
    }

    public CipherParameters decrypt(byte[] byArray, int n2) {
        return this.decrypt(byArray, 0, byArray.length, n2);
    }
}

