/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.macs;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Mac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.paddings.ISO7816d4Padding;

public class CMac
implements Mac {
    private static final byte CONSTANT_128 = -121;
    private static final byte CONSTANT_64 = 27;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] L;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public CMac(BlockCipher blockCipher, int n2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (n2 > blockCipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + blockCipher.getBlockSize() * 8);
        }
        if (blockCipher.getBlockSize() != 8 && blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Block size must be either 64 or 128 bits");
        }
        this.cipher = new CBCBlockCipher(blockCipher);
        this.macSize = n2 / 8;
        this.mac = new byte[blockCipher.getBlockSize()];
        this.buf = new byte[blockCipher.getBlockSize()];
        this.ZEROES = new byte[blockCipher.getBlockSize()];
        this.bufOff = 0;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    private static byte[] doubleLu(byte[] byArray) {
        int n2 = (byArray[0] & 0xFF) >> 7;
        byte[] byArray2 = new byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length - 1; ++i2) {
            byArray2[i2] = (byte)((byArray[i2] << 1) + ((byArray[i2 + 1] & 0xFF) >> 7));
        }
        byArray2[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << 1);
        if (n2 == 1) {
            int n3 = byArray.length - 1;
            byArray2[n3] = (byte)(byArray2[n3] ^ (byArray.length == 16 ? -121 : 27));
        }
        return byArray2;
    }

    public void init(CipherParameters cipherParameters) {
        if (cipherParameters != null) {
            this.cipher.init(true, cipherParameters);
            this.L = new byte[this.ZEROES.length];
            this.cipher.processBlock(this.ZEROES, 0, this.L, 0);
            this.Lu = CMac.doubleLu(this.L);
            this.Lu2 = CMac.doubleLu(this.Lu);
        }
        this.reset();
    }

    public int getMacSize() {
        return this.macSize;
    }

    public void update(byte by2) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = by2;
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.cipher.getBlockSize();
        int n5 = n4 - this.bufOff;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.buf, this.bufOff, n5);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.cipher.processBlock(byArray, n2, this.mac, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.buf, this.bufOff, n3);
        this.bufOff += n3;
    }

    public int doFinal(byte[] byArray, int n2) {
        byte[] byArray2;
        int n3 = this.cipher.getBlockSize();
        if (this.bufOff == n3) {
            byArray2 = this.Lu;
        } else {
            new ISO7816d4Padding().addPadding(this.buf, this.bufOff);
            byArray2 = this.Lu2;
        }
        for (int i2 = 0; i2 < this.mac.length; ++i2) {
            int n4 = i2;
            this.buf[n4] = (byte)(this.buf[n4] ^ byArray2[i2]);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, byArray, n2, this.macSize);
        this.reset();
        return this.macSize;
    }

    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

