/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.modes;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DataLengthException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.AEADBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.SICBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AEADParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithIV;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;

public class CCMBlockCipher
implements AEADBlockCipher {
    private BlockCipher cipher;
    private int blockSize;
    private boolean forEncryption;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private int macSize;
    private CipherParameters keyParam;
    private byte[] macBlock;
    private ByteArrayOutputStream associatedText = new ByteArrayOutputStream();
    private ByteArrayOutputStream data = new ByteArrayOutputStream();

    public CCMBlockCipher(BlockCipher blockCipher) {
        this.cipher = blockCipher;
        this.blockSize = blockCipher.getBlockSize();
        this.macBlock = new byte[this.blockSize];
        if (this.blockSize != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl2;
        if (cipherParameters instanceof AEADParameters) {
            AEADParameters aEADParameters = (AEADParameters)cipherParameters;
            this.nonce = aEADParameters.getNonce();
            this.initialAssociatedText = aEADParameters.getAssociatedText();
            this.macSize = aEADParameters.getMacSize() / 8;
            this.keyParam = aEADParameters.getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            this.nonce = parametersWithIV.getIV();
            this.initialAssociatedText = null;
            this.macSize = this.macBlock.length / 2;
            this.keyParam = parametersWithIV.getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to CCM");
        }
        if (this.nonce == null || this.nonce.length < 7 || this.nonce.length > 13) {
            throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
        }
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/CCM";
    }

    public void processAADByte(byte by2) {
        this.associatedText.write(by2);
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        this.associatedText.write(byArray, n2, n3);
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException, IllegalStateException {
        this.data.write(by2);
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException, IllegalStateException {
        this.data.write(byArray, n2, n3);
        return 0;
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        byte[] byArray2 = this.data.toByteArray();
        byte[] byArray3 = this.processPacket(byArray2, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray, n2, byArray3.length);
        this.reset();
        return byArray3.length;
    }

    public void reset() {
        this.cipher.reset();
        this.associatedText.reset();
        this.data.reset();
    }

    public byte[] getMac() {
        byte[] byArray = new byte[this.macSize];
        System.arraycopy(this.macBlock, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public int getUpdateOutputSize(int n2) {
        return 0;
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.data.size();
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public byte[] processPacket(byte[] byArray, int n2, int n3) throws IllegalStateException, InvalidCipherTextException {
        int n4;
        byte[] byArray2;
        int n5;
        if (this.keyParam == null) {
            throw new IllegalStateException("CCM cipher unitialized.");
        }
        int n6 = this.nonce.length;
        int n7 = 15 - n6;
        if (n7 < 4 && n3 >= (n5 = 1 << 8 * n7)) {
            throw new IllegalStateException("CCM packet too large for choice of q.");
        }
        byte[] byArray3 = new byte[this.blockSize];
        byArray3[0] = (byte)(n7 - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        SICBlockCipher sICBlockCipher = new SICBlockCipher(this.cipher);
        sICBlockCipher.init(this.forEncryption, new ParametersWithIV(this.keyParam, byArray3));
        int n8 = 0;
        if (this.forEncryption) {
            byArray2 = new byte[n3 + this.macSize];
            this.calculateMac(byArray, n2, n3, this.macBlock);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (n4 = n2; n4 < n3 - this.blockSize; n4 += this.blockSize) {
                sICBlockCipher.processBlock(byArray, n4, byArray2, n8);
                n8 += this.blockSize;
            }
            byte[] byArray4 = new byte[this.blockSize];
            System.arraycopy(byArray, n4, byArray4, 0, n3 - n4);
            sICBlockCipher.processBlock(byArray4, 0, byArray4, 0);
            System.arraycopy(byArray4, 0, byArray2, n8, n3 - n4);
            System.arraycopy(this.macBlock, 0, byArray2, n8 += n3 - n4, byArray2.length - n8);
        } else {
            byArray2 = new byte[n3 - this.macSize];
            System.arraycopy(byArray, n2 + n3 - this.macSize, this.macBlock, 0, this.macSize);
            sICBlockCipher.processBlock(this.macBlock, 0, this.macBlock, 0);
            for (int i2 = this.macSize; i2 != this.macBlock.length; ++i2) {
                this.macBlock[i2] = 0;
            }
            while (n8 < byArray2.length - this.blockSize) {
                sICBlockCipher.processBlock(byArray, n4, byArray2, n8);
                n8 += this.blockSize;
                n4 += this.blockSize;
            }
            byte[] byArray5 = new byte[this.blockSize];
            System.arraycopy(byArray, n4, byArray5, 0, byArray2.length - n8);
            sICBlockCipher.processBlock(byArray5, 0, byArray5, 0);
            System.arraycopy(byArray5, 0, byArray2, n8, byArray2.length - n8);
            byte[] byArray6 = new byte[this.blockSize];
            this.calculateMac(byArray2, 0, byArray2.length, byArray6);
            if (!Arrays.constantTimeAreEqual(this.macBlock, byArray6)) {
                throw new InvalidCipherTextException("mac check in CCM failed");
            }
        }
        return byArray2;
    }

    private int calculateMac(byte[] byArray, int n2, int n3, byte[] byArray2) {
        CBCBlockCipherMac cBCBlockCipherMac = new CBCBlockCipherMac(this.cipher, this.macSize * 8);
        cBCBlockCipherMac.init(this.keyParam);
        byte[] byArray3 = new byte[16];
        if (this.hasAssociatedText()) {
            byArray3[0] = (byte)(byArray3[0] | 0x40);
        }
        byArray3[0] = (byte)(byArray3[0] | ((cBCBlockCipherMac.getMacSize() - 2) / 2 & 7) << 3);
        byArray3[0] = (byte)(byArray3[0] | 15 - this.nonce.length - 1 & 7);
        System.arraycopy(this.nonce, 0, byArray3, 1, this.nonce.length);
        int n4 = n3;
        int n5 = 1;
        while (n4 > 0) {
            byArray3[byArray3.length - n5] = (byte)(n4 & 0xFF);
            n4 >>>= 8;
            ++n5;
        }
        cBCBlockCipherMac.update(byArray3, 0, byArray3.length);
        if (this.hasAssociatedText()) {
            int n6;
            int n7 = this.getAssociatedTextLength();
            if (n7 < 65280) {
                cBCBlockCipherMac.update((byte)(n7 >> 8));
                cBCBlockCipherMac.update((byte)n7);
                n6 = 2;
            } else {
                cBCBlockCipherMac.update((byte)-1);
                cBCBlockCipherMac.update((byte)-2);
                cBCBlockCipherMac.update((byte)(n7 >> 24));
                cBCBlockCipherMac.update((byte)(n7 >> 16));
                cBCBlockCipherMac.update((byte)(n7 >> 8));
                cBCBlockCipherMac.update((byte)n7);
                n6 = 6;
            }
            if (this.initialAssociatedText != null) {
                cBCBlockCipherMac.update(this.initialAssociatedText, 0, this.initialAssociatedText.length);
            }
            if (this.associatedText.size() > 0) {
                byte[] byArray4 = this.associatedText.toByteArray();
                cBCBlockCipherMac.update(byArray4, 0, byArray4.length);
            }
            if ((n6 = (n6 + n7) % 16) != 0) {
                for (int i2 = n6; i2 != 16; ++i2) {
                    cBCBlockCipherMac.update((byte)0);
                }
            }
        }
        cBCBlockCipherMac.update(byArray, n2, n3);
        return cBCBlockCipherMac.doFinal(byArray2, 0);
    }

    private int getAssociatedTextLength() {
        return this.associatedText.size() + (this.initialAssociatedText == null ? 0 : this.initialAssociatedText.length);
    }

    private boolean hasAssociatedText() {
        return this.getAssociatedTextLength() > 0;
    }
}

