/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.modes;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DataLengthException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.AEADBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.gcm.Tables1kGCMExponentiator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.gcm.Tables8kGCMMultiplier;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AEADParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.KeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithIV;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.util.Pack;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;

public class GCMBlockCipher
implements AEADBlockCipher {
    private static final int BLOCK_SIZE = 16;
    private BlockCipher cipher;
    private GCMMultiplier multiplier;
    private GCMExponentiator exp;
    private boolean forEncryption;
    private int macSize;
    private byte[] nonce;
    private byte[] initialAssociatedText;
    private byte[] H;
    private byte[] J0;
    private byte[] bufBlock;
    private byte[] macBlock;
    private byte[] S;
    private byte[] S_at;
    private byte[] S_atPre;
    private byte[] counter;
    private int bufOff;
    private long totalLength;
    private byte[] atBlock;
    private int atBlockPos;
    private long atLength;
    private long atLengthPre;

    public GCMBlockCipher(BlockCipher blockCipher) {
        this(blockCipher, null);
    }

    public GCMBlockCipher(BlockCipher blockCipher, GCMMultiplier gCMMultiplier) {
        if (blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("cipher required with a block size of 16.");
        }
        if (gCMMultiplier == null) {
            gCMMultiplier = new Tables8kGCMMultiplier();
        }
        this.cipher = blockCipher;
        this.multiplier = gCMMultiplier;
    }

    public BlockCipher getUnderlyingCipher() {
        return this.cipher;
    }

    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName() + "/GCM";
    }

    public void init(boolean bl2, CipherParameters cipherParameters) throws IllegalArgumentException {
        KeyParameter keyParameter;
        CipherParameters cipherParameters2;
        this.forEncryption = bl2;
        this.macBlock = null;
        if (cipherParameters instanceof AEADParameters) {
            cipherParameters2 = (AEADParameters)cipherParameters;
            this.nonce = ((AEADParameters)cipherParameters2).getNonce();
            this.initialAssociatedText = ((AEADParameters)cipherParameters2).getAssociatedText();
            int n2 = ((AEADParameters)cipherParameters2).getMacSize();
            if (n2 < 96 || n2 > 128 || n2 % 8 != 0) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + n2);
            }
            this.macSize = n2 / 8;
            keyParameter = ((AEADParameters)cipherParameters2).getKey();
        } else if (cipherParameters instanceof ParametersWithIV) {
            cipherParameters2 = (ParametersWithIV)cipherParameters;
            this.nonce = ((ParametersWithIV)cipherParameters2).getIV();
            this.initialAssociatedText = null;
            this.macSize = 16;
            keyParameter = (KeyParameter)((ParametersWithIV)cipherParameters2).getParameters();
        } else {
            throw new IllegalArgumentException("invalid parameters passed to GCM");
        }
        int n3 = bl2 ? 16 : 16 + this.macSize;
        this.bufBlock = new byte[n3];
        if (this.nonce == null || this.nonce.length < 1) {
            throw new IllegalArgumentException("IV must be at least 1 byte");
        }
        if (keyParameter != null) {
            this.cipher.init(true, keyParameter);
            this.H = new byte[16];
            this.cipher.processBlock(this.H, 0, this.H, 0);
            this.multiplier.init(this.H);
            this.exp = null;
        }
        this.J0 = new byte[16];
        if (this.nonce.length == 12) {
            System.arraycopy(this.nonce, 0, this.J0, 0, this.nonce.length);
            this.J0[15] = 1;
        } else {
            this.gHASH(this.J0, this.nonce, this.nonce.length);
            byte[] byArray = new byte[16];
            Pack.longToBigEndian((long)this.nonce.length * 8L, byArray, 8);
            this.gHASHBlock(this.J0, byArray);
        }
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public byte[] getMac() {
        return Arrays.clone(this.macBlock);
    }

    public int getOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (this.forEncryption) {
            return n3 + this.macSize;
        }
        return n3 < this.macSize ? 0 : n3 - this.macSize;
    }

    public int getUpdateOutputSize(int n2) {
        int n3 = n2 + this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                return 0;
            }
            n3 -= this.macSize;
        }
        return n3 - n3 % 16;
    }

    public void processAADByte(byte by2) {
        this.atBlock[this.atBlockPos] = by2;
        if (++this.atBlockPos == 16) {
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    public void processAADBytes(byte[] byArray, int n2, int n3) {
        for (int i2 = 0; i2 < n3; ++i2) {
            this.atBlock[this.atBlockPos] = byArray[n2 + i2];
            if (++this.atBlockPos != 16) continue;
            this.gHASHBlock(this.S_at, this.atBlock);
            this.atBlockPos = 0;
            this.atLength += 16L;
        }
    }

    private void initCipher() {
        if (this.atLength > 0L) {
            System.arraycopy(this.S_at, 0, this.S_atPre, 0, 16);
            this.atLengthPre = this.atLength;
        }
        if (this.atBlockPos > 0) {
            this.gHASHPartial(this.S_atPre, this.atBlock, 0, this.atBlockPos);
            this.atLengthPre += (long)this.atBlockPos;
        }
        if (this.atLengthPre > 0L) {
            System.arraycopy(this.S_atPre, 0, this.S, 0, 16);
        }
    }

    public int processByte(byte by2, byte[] byArray, int n2) throws DataLengthException {
        this.bufBlock[this.bufOff] = by2;
        if (++this.bufOff == this.bufBlock.length) {
            this.outputBlock(byArray, n2);
            return 16;
        }
        return 0;
    }

    public int processBytes(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws DataLengthException {
        int n5 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.bufBlock[this.bufOff] = byArray[n2 + i2];
            if (++this.bufOff != this.bufBlock.length) continue;
            this.outputBlock(byArray2, n4 + n5);
            n5 += 16;
        }
        return n5;
    }

    private void outputBlock(byte[] byArray, int n2) {
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        this.gCTRBlock(this.bufBlock, byArray, n2);
        if (this.forEncryption) {
            this.bufOff = 0;
        } else {
            System.arraycopy(this.bufBlock, 16, this.bufBlock, 0, this.macSize);
            this.bufOff = this.macSize;
        }
    }

    public int doFinal(byte[] byArray, int n2) throws IllegalStateException, InvalidCipherTextException {
        if (this.totalLength == 0L) {
            this.initCipher();
        }
        int n3 = this.bufOff;
        if (!this.forEncryption) {
            if (n3 < this.macSize) {
                throw new InvalidCipherTextException("data too short");
            }
            n3 -= this.macSize;
        }
        if (n3 > 0) {
            this.gCTRPartial(this.bufBlock, 0, n3, byArray, n2);
        }
        this.atLength += (long)this.atBlockPos;
        if (this.atLength > this.atLengthPre) {
            if (this.atBlockPos > 0) {
                this.gHASHPartial(this.S_at, this.atBlock, 0, this.atBlockPos);
            }
            if (this.atLengthPre > 0L) {
                GCMBlockCipher.xor(this.S_at, this.S_atPre);
            }
            long l2 = this.totalLength * 8L + 127L >>> 7;
            byte[] byArray2 = new byte[16];
            if (this.exp == null) {
                this.exp = new Tables1kGCMExponentiator();
                this.exp.init(this.H);
            }
            this.exp.exponentiateX(l2, byArray2);
            GCMBlockCipher.multiply(this.S_at, byArray2);
            GCMBlockCipher.xor(this.S, this.S_at);
        }
        byte[] byArray3 = new byte[16];
        Pack.longToBigEndian(this.atLength * 8L, byArray3, 0);
        Pack.longToBigEndian(this.totalLength * 8L, byArray3, 8);
        this.gHASHBlock(this.S, byArray3);
        byte[] byArray4 = new byte[16];
        this.cipher.processBlock(this.J0, 0, byArray4, 0);
        GCMBlockCipher.xor(byArray4, this.S);
        int n4 = n3;
        this.macBlock = new byte[this.macSize];
        System.arraycopy(byArray4, 0, this.macBlock, 0, this.macSize);
        if (this.forEncryption) {
            System.arraycopy(this.macBlock, 0, byArray, n2 + this.bufOff, this.macSize);
            n4 += this.macSize;
        } else {
            byte[] byArray5 = new byte[this.macSize];
            System.arraycopy(this.bufBlock, n3, byArray5, 0, this.macSize);
            if (!Arrays.constantTimeAreEqual(this.macBlock, byArray5)) {
                throw new InvalidCipherTextException("mac check in GCM failed");
            }
        }
        this.reset(false);
        return n4;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean bl2) {
        this.cipher.reset();
        this.S = new byte[16];
        this.S_at = new byte[16];
        this.S_atPre = new byte[16];
        this.atBlock = new byte[16];
        this.atBlockPos = 0;
        this.atLength = 0L;
        this.atLengthPre = 0L;
        this.counter = Arrays.clone(this.J0);
        this.bufOff = 0;
        this.totalLength = 0L;
        if (this.bufBlock != null) {
            Arrays.fill(this.bufBlock, (byte)0);
        }
        if (bl2) {
            this.macBlock = null;
        }
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    private void gCTRBlock(byte[] byArray, byte[] byArray2, int n2) {
        byte[] byArray3 = this.getNextCounterBlock();
        GCMBlockCipher.xor(byArray3, byArray);
        System.arraycopy(byArray3, 0, byArray2, n2, 16);
        this.gHASHBlock(this.S, this.forEncryption ? byArray3 : byArray);
        this.totalLength += 16L;
    }

    private void gCTRPartial(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = this.getNextCounterBlock();
        GCMBlockCipher.xor(byArray3, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, n3);
        this.gHASHPartial(this.S, this.forEncryption ? byArray3 : byArray, 0, n3);
        this.totalLength += (long)n3;
    }

    private void gHASH(byte[] byArray, byte[] byArray2, int n2) {
        for (int i2 = 0; i2 < n2; i2 += 16) {
            int n3 = Math.min(n2 - i2, 16);
            this.gHASHPartial(byArray, byArray2, i2, n3);
        }
    }

    private void gHASHBlock(byte[] byArray, byte[] byArray2) {
        GCMBlockCipher.xor(byArray, byArray2);
        this.multiplier.multiplyH(byArray);
    }

    private void gHASHPartial(byte[] byArray, byte[] byArray2, int n2, int n3) {
        GCMBlockCipher.xor(byArray, byArray2, n2, n3);
        this.multiplier.multiplyH(byArray);
    }

    private byte[] getNextCounterBlock() {
        for (int i2 = 15; i2 >= 12; --i2) {
            byte by2;
            this.counter[i2] = by2 = (byte)(this.counter[i2] + 1 & 0xFF);
            if (by2 != 0) break;
        }
        byte[] byArray = new byte[16];
        this.cipher.processBlock(this.counter, 0, byArray, 0);
        return byArray;
    }

    private static void multiply(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = Arrays.clone(byArray);
        byte[] byArray4 = new byte[16];
        for (int i2 = 0; i2 < 16; ++i2) {
            byte by2 = byArray2[i2];
            for (int i3 = 7; i3 >= 0; --i3) {
                if ((by2 & 1 << i3) != 0) {
                    GCMBlockCipher.xor(byArray4, byArray3);
                }
                boolean bl2 = (byArray3[15] & 1) != 0;
                GCMBlockCipher.shiftRight(byArray3);
                if (!bl2) continue;
                byArray3[0] = (byte)(byArray3[0] ^ 0xFFFFFFE1);
            }
        }
        System.arraycopy(byArray4, 0, byArray, 0, 16);
    }

    private static void shiftRight(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4 = byArray[n2] & 0xFF;
            byArray[n2] = (byte)(n4 >>> 1 | n3);
            if (++n2 == 16) break;
            n3 = (n4 & 1) << 7;
        }
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i2 = 15; i2 >= 0; --i2) {
            int n2 = i2;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[i2]);
        }
    }

    private static void xor(byte[] byArray, byte[] byArray2, int n2, int n3) {
        while (n3-- > 0) {
            int n4 = n3;
            byArray[n4] = (byte)(byArray[n4] ^ byArray2[n2 + n3]);
        }
    }
}

