/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.paddings;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.InvalidCipherTextException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import java.security.SecureRandom;

public class X923Padding
implements BlockCipherPadding {
    SecureRandom a = null;

    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.a = secureRandom;
    }

    public String getPaddingName() {
        return "X9.23";
    }

    public int addPadding(byte[] byArray, int n2) {
        byte by2 = (byte)(byArray.length - n2);
        while (n2 < byArray.length - 1) {
            byArray[n2] = this.a == null ? (byte)0 : (byte)this.a.nextInt();
            ++n2;
        }
        byArray[n2] = by2;
        return by2;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

