/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.signers;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CipherParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DSA;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import java.math.BigInteger;
import java.security.SecureRandom;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSASigner
implements DSA {
    DSAKeyParameters a;
    SecureRandom a;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.a = parametersWithRandom.getRandom();
                this.a = (DSAPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.a = new SecureRandom();
                this.a = (DSAPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.a = (DSAPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        DSAParameters dSAParameters = this.a.getParameters();
        BigInteger bigInteger2 = this.calculateE(dSAParameters.getQ(), byArray);
        int n2 = dSAParameters.getQ().bitLength();
        while ((bigInteger = new BigInteger(n2, this.a)).compareTo(dSAParameters.getQ()) >= 0) {
        }
        BigInteger bigInteger3 = dSAParameters.getG().modPow(bigInteger, dSAParameters.getP()).mod(dSAParameters.getQ());
        bigInteger = bigInteger.modInverse(dSAParameters.getQ()).multiply(bigInteger2.add(((DSAPrivateKeyParameters)this.a).getX().multiply(bigInteger3)));
        BigInteger bigInteger4 = bigInteger.mod(dSAParameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DSAParameters dSAParameters = this.a.getParameters();
        BigInteger bigInteger3 = this.calculateE(dSAParameters.getQ(), byArray);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || dSAParameters.getQ().compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || dSAParameters.getQ().compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(dSAParameters.getQ());
        BigInteger bigInteger6 = bigInteger3.multiply(bigInteger5).mod(dSAParameters.getQ());
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(dSAParameters.getQ());
        bigInteger6 = dSAParameters.getG().modPow(bigInteger6, dSAParameters.getP());
        bigInteger7 = ((DSAPublicKeyParameters)this.a).getY().modPow(bigInteger7, dSAParameters.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(dSAParameters.getP()).mod(dSAParameters.getQ());
        return bigInteger8.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }
}

