/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1InputStream;
import com.zeroturnaround.bundled.org.bouncycastle.asn1.ASN1Primitive;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[0]);
    protected com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] certificateList;

    public Certificate(com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        if (certificateArray == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateArray;
    }

    public com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] getCerts() {
        return this.clone(this.certificateList);
    }

    public com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] getCertificateList() {
        return this.clone(this.certificateList);
    }

    public com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate getCertificateAt(int n2) {
        return this.certificateList[n2];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        byte[] byArray;
        int n2;
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n3 = 0;
        for (n2 = 0; n2 < this.certificateList.length; ++n2) {
            byArray = this.certificateList[n2].getEncoded("DER");
            vector.addElement(byArray);
            n3 += byArray.length + 3;
        }
        TlsUtils.writeUint24(n3, outputStream);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            byArray = (byte[])vector.elementAt(n2);
            TlsUtils.writeOpaque24(byArray, outputStream);
        }
    }

    public static Certificate parse(InputStream inputStream) throws IOException {
        int n2;
        int n3 = TlsUtils.readUint24(inputStream);
        if (n3 == 0) {
            return EMPTY_CHAIN;
        }
        Vector<com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate> vector = new Vector<com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate>();
        while (n3 > 0) {
            n2 = TlsUtils.readUint24(inputStream);
            n3 -= 3 + n2;
            byte[] byArray = TlsUtils.readFully(n2, inputStream);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1Primitive aSN1Primitive = new ASN1InputStream(byteArrayInputStream).readObject();
            TlsProtocol.assertEmpty(byteArrayInputStream);
            vector.addElement(com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Primitive));
        }
        com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] certificateArray = new com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            certificateArray[n2] = (com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate)vector.elementAt(n2);
        }
        return new Certificate(certificateArray);
    }

    private com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] clone(com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] certificateArray) {
        com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[] certificateArray2 = new com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.Certificate[certificateArray.length];
        System.arraycopy(certificateArray, 0, certificateArray2, 0, certificateArray2.length);
        return certificateArray2;
    }
}

