/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CertificateRequest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSClientProtocol$ClientHandshakeState;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSRecordLayer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSReliableHandshake$Message;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DTLSTransport;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.DatagramTransport;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.NewSessionTicket;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.ProtocolVersion;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsClient;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsClientContextImpl;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import com.zeroturnaround.bundled.org.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSClientProtocol(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public DTLSTransport connect(TlsClient tlsClient, DatagramTransport datagramTransport) throws IOException {
        if (tlsClient == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 1;
        securityParameters.b = TlsProtocol.createRandomBlock(this.secureRandom);
        DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState = new DTLSClientProtocol$ClientHandshakeState();
        dTLSClientProtocol$ClientHandshakeState.a = tlsClient;
        dTLSClientProtocol$ClientHandshakeState.a = new TlsClientContextImpl(this.secureRandom, securityParameters);
        tlsClient.init(dTLSClientProtocol$ClientHandshakeState.a);
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, dTLSClientProtocol$ClientHandshakeState.a, tlsClient, 22);
        try {
            return this.clientHandshake(dTLSClientProtocol$ClientHandshakeState, dTLSRecordLayer);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            dTLSRecordLayer.a(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            dTLSRecordLayer.a((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            dTLSRecordLayer.a((short)80);
            throw new TlsFatalAlert(80);
        }
    }

    protected DTLSTransport clientHandshake(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        byte[] byArray;
        Object object;
        SecurityParameters securityParameters = dTLSClientProtocol$ClientHandshakeState.a.getSecurityParameters();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(dTLSClientProtocol$ClientHandshakeState.a, dTLSRecordLayer);
        byte[] byArray2 = this.generateClientHello(dTLSClientProtocol$ClientHandshakeState, dTLSClientProtocol$ClientHandshakeState.a);
        dTLSReliableHandshake.a((short)1, byArray2);
        DTLSReliableHandshake$Message dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        Object object2 = dTLSRecordLayer.a();
        Object object3 = dTLSClientProtocol$ClientHandshakeState.a.getClientVersion();
        if (!((ProtocolVersion)object2).isEqualOrEarlierVersionOf((ProtocolVersion)object3)) {
            throw new TlsFatalAlert(47);
        }
        dTLSClientProtocol$ClientHandshakeState.a.setServerVersion((ProtocolVersion)object2);
        dTLSClientProtocol$ClientHandshakeState.a.notifyServerVersion((ProtocolVersion)object2);
        while (dTLSReliableHandshake$Message.getType() == 3) {
            object2 = DTLSClientProtocol.parseHelloVerifyRequest(dTLSClientProtocol$ClientHandshakeState.a, dTLSReliableHandshake$Message.getBody());
            object3 = DTLSClientProtocol.patchClientHelloWithCookie(byArray2, (byte[])object2);
            dTLSReliableHandshake.c();
            dTLSReliableHandshake.a((short)1, (byte[])object3);
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        }
        if (dTLSReliableHandshake$Message.getType() != 2) {
            throw new TlsFatalAlert(10);
        }
        this.processServerHello(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
        dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        securityParameters.b = TlsProtocol.getPRFAlgorithm(dTLSClientProtocol$ClientHandshakeState.a);
        securityParameters.a = dTLSClientProtocol$ClientHandshakeState.a;
        securityParameters.c = 12;
        dTLSReliableHandshake.a();
        if (dTLSReliableHandshake$Message.getType() == 23) {
            this.processServerSupplementalData(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        } else {
            dTLSClientProtocol$ClientHandshakeState.a.processServerSupplementalData(null);
        }
        dTLSClientProtocol$ClientHandshakeState.a = dTLSClientProtocol$ClientHandshakeState.a.getKeyExchange();
        dTLSClientProtocol$ClientHandshakeState.a.init(dTLSClientProtocol$ClientHandshakeState.a);
        if (dTLSReliableHandshake$Message.getType() == 11) {
            this.processServerCertificate(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        } else {
            dTLSClientProtocol$ClientHandshakeState.a.skipServerCredentials();
        }
        if (dTLSReliableHandshake$Message.getType() == 12) {
            this.processServerKeyExchange(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        } else {
            dTLSClientProtocol$ClientHandshakeState.a.skipServerKeyExchange();
        }
        if (dTLSReliableHandshake$Message.getType() == 13) {
            this.processCertificateRequest(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        }
        if (dTLSReliableHandshake$Message.getType() == 14) {
            if (dTLSReliableHandshake$Message.getBody().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object2 = dTLSClientProtocol$ClientHandshakeState.a.getClientSupplementalData();
        if (object2 != null) {
            object3 = DTLSClientProtocol.generateSupplementalData((Vector)object2);
            dTLSReliableHandshake.a((short)23, (byte[])object3);
        }
        if (dTLSClientProtocol$ClientHandshakeState.a != null) {
            dTLSClientProtocol$ClientHandshakeState.a = dTLSClientProtocol$ClientHandshakeState.a.getClientCredentials(dTLSClientProtocol$ClientHandshakeState.a);
            object3 = null;
            if (dTLSClientProtocol$ClientHandshakeState.a != null) {
                object3 = dTLSClientProtocol$ClientHandshakeState.a.getCertificate();
            }
            if (object3 == null) {
                object3 = Certificate.EMPTY_CHAIN;
            }
            object = DTLSClientProtocol.generateCertificate((Certificate)object3);
            dTLSReliableHandshake.a((short)11, (byte[])object);
        }
        if (dTLSClientProtocol$ClientHandshakeState.a != null) {
            dTLSClientProtocol$ClientHandshakeState.a.processClientCredentials(dTLSClientProtocol$ClientHandshakeState.a);
        } else {
            dTLSClientProtocol$ClientHandshakeState.a.skipClientCredentials();
        }
        object3 = this.generateClientKeyExchange(dTLSClientProtocol$ClientHandshakeState);
        dTLSReliableHandshake.a((short)16, (byte[])object3);
        TlsProtocol.establishMasterSecret(dTLSClientProtocol$ClientHandshakeState.a, dTLSClientProtocol$ClientHandshakeState.a);
        if (dTLSClientProtocol$ClientHandshakeState.a instanceof TlsSignerCredentials) {
            object = (TlsSignerCredentials)dTLSClientProtocol$ClientHandshakeState.a;
            byArray = dTLSReliableHandshake.a();
            byte[] byArray3 = object.generateCertificateSignature(byArray);
            byte[] byArray4 = this.generateCertificateVerify(dTLSClientProtocol$ClientHandshakeState, byArray3);
            dTLSReliableHandshake.a((short)15, byArray4);
        }
        dTLSRecordLayer.a(dTLSClientProtocol$ClientHandshakeState.a.getCipher());
        object = TlsUtils.a(dTLSClientProtocol$ClientHandshakeState.a, "client finished", dTLSReliableHandshake.a());
        dTLSReliableHandshake.a((short)20, (byte[])object);
        if (dTLSClientProtocol$ClientHandshakeState.b) {
            dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
            if (dTLSReliableHandshake$Message.getType() == 4) {
                this.processNewSessionTicket(dTLSClientProtocol$ClientHandshakeState, dTLSReliableHandshake$Message.getBody());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byArray = TlsUtils.a(dTLSClientProtocol$ClientHandshakeState.a, "server finished", dTLSReliableHandshake.a());
        dTLSReliableHandshake$Message = dTLSReliableHandshake.a();
        if (dTLSReliableHandshake$Message.getType() != 20) {
            throw new TlsFatalAlert(10);
        }
        this.processFinished(dTLSReliableHandshake$Message.getBody(), byArray);
        dTLSReliableHandshake.b();
        dTLSClientProtocol$ClientHandshakeState.a.notifyHandshakeComplete();
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateVerify(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, TlsClient tlsClient) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = tlsClient.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        dTLSClientProtocol$ClientHandshakeState.a.setClientVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        byteArrayOutputStream.write(dTLSClientProtocol$ClientHandshakeState.a.getSecurityParameters().getClientRandom());
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        dTLSClientProtocol$ClientHandshakeState.a = tlsClient.getCipherSuites();
        dTLSClientProtocol$ClientHandshakeState.a = tlsClient.getClientExtensions();
        boolean bl2 = dTLSClientProtocol$ClientHandshakeState.a == null || dTLSClientProtocol$ClientHandshakeState.a.get(TlsProtocol.EXT_RenegotiationInfo) == null;
        int n2 = dTLSClientProtocol$ClientHandshakeState.a.length;
        if (bl2) {
            ++n2;
        }
        TlsUtils.writeUint16(2 * n2, byteArrayOutputStream);
        TlsUtils.writeUint16Array(dTLSClientProtocol$ClientHandshakeState.a, byteArrayOutputStream);
        if (bl2) {
            TlsUtils.writeUint16(255, byteArrayOutputStream);
        }
        dTLSClientProtocol$ClientHandshakeState.a = new short[]{0};
        TlsUtils.writeUint8((short)dTLSClientProtocol$ClientHandshakeState.a.length, byteArrayOutputStream);
        TlsUtils.writeUint8Array(dTLSClientProtocol$ClientHandshakeState.a, byteArrayOutputStream);
        if (dTLSClientProtocol$ClientHandshakeState.a != null) {
            TlsProtocol.writeExtensions(byteArrayOutputStream, dTLSClientProtocol$ClientHandshakeState.a);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        dTLSClientProtocol$ClientHandshakeState.a.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void processCertificateRequest(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        if (dTLSClientProtocol$ClientHandshakeState.a == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        dTLSClientProtocol$ClientHandshakeState.a = CertificateRequest.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        dTLSClientProtocol$ClientHandshakeState.a.validateCertificateRequest(dTLSClientProtocol$ClientHandshakeState.a);
    }

    protected void processNewSessionTicket(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        dTLSClientProtocol$ClientHandshakeState.a.notifyNewSessionTicket(newSessionTicket);
    }

    protected void processServerCertificate(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        dTLSClientProtocol$ClientHandshakeState.a.processServerCertificate(certificate);
        dTLSClientProtocol$ClientHandshakeState.a = dTLSClientProtocol$ClientHandshakeState.a.getAuthentication();
        dTLSClientProtocol$ClientHandshakeState.a.notifyServerCertificate(certificate);
    }

    protected void processServerHello(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        SecurityParameters securityParameters = dTLSClientProtocol$ClientHandshakeState.a.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.equals(dTLSClientProtocol$ClientHandshakeState.a.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        securityParameters.c = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream);
        if (byArray2.length > 32) {
            throw new TlsFatalAlert(47);
        }
        dTLSClientProtocol$ClientHandshakeState.a.notifySessionID(byArray2);
        dTLSClientProtocol$ClientHandshakeState.a = TlsUtils.readUint16(byteArrayInputStream);
        if (!TlsProtocol.arrayContains(dTLSClientProtocol$ClientHandshakeState.a, dTLSClientProtocol$ClientHandshakeState.a) || dTLSClientProtocol$ClientHandshakeState.a == 0 || dTLSClientProtocol$ClientHandshakeState.a == 255) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(dTLSClientProtocol$ClientHandshakeState.a, (short)47);
        dTLSClientProtocol$ClientHandshakeState.a.notifySelectedCipherSuite(dTLSClientProtocol$ClientHandshakeState.a);
        dTLSClientProtocol$ClientHandshakeState.a = TlsUtils.readUint8(byteArrayInputStream);
        if (!TlsProtocol.arrayContains(dTLSClientProtocol$ClientHandshakeState.a, dTLSClientProtocol$ClientHandshakeState.a)) {
            throw new TlsFatalAlert(47);
        }
        dTLSClientProtocol$ClientHandshakeState.a.notifySelectedCompressionMethod(dTLSClientProtocol$ClientHandshakeState.a);
        Hashtable hashtable = TlsProtocol.readExtensions(byteArrayInputStream);
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (Integer)enumeration.nextElement();
                if (((Integer)object).equals(TlsProtocol.EXT_RenegotiationInfo) || dTLSClientProtocol$ClientHandshakeState.a != null && dTLSClientProtocol$ClientHandshakeState.a.get(object) != null) continue;
                throw new TlsFatalAlert(110);
            }
            object = (byte[])hashtable.get(TlsProtocol.EXT_RenegotiationInfo);
            if (object != null) {
                dTLSClientProtocol$ClientHandshakeState.a = true;
                if (!Arrays.constantTimeAreEqual((byte[])object, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                    throw new TlsFatalAlert(40);
                }
            }
            dTLSClientProtocol$ClientHandshakeState.b = hashtable.containsKey(TlsProtocol.EXT_SessionTicket);
        }
        dTLSClientProtocol$ClientHandshakeState.a.notifySecureRenegotiation(dTLSClientProtocol$ClientHandshakeState.a);
        if (dTLSClientProtocol$ClientHandshakeState.a != null) {
            dTLSClientProtocol$ClientHandshakeState.a.processServerExtensions(hashtable);
        }
    }

    protected void processServerKeyExchange(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        dTLSClientProtocol$ClientHandshakeState.a.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(DTLSClientProtocol$ClientHandshakeState dTLSClientProtocol$ClientHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        dTLSClientProtocol$ClientHandshakeState.a.processServerSupplementalData(vector);
    }

    protected static byte[] parseHelloVerifyRequest(TlsContext tlsContext, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        if (!protocolVersion.equals(tlsContext.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        byte[] byArray2 = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return byArray2;
    }

    protected static byte[] patchClientHelloWithCookie(byte[] byArray, byte[] byArray2) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8(byArray, n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        TlsUtils.writeUint8((short)byArray2.length, byArray3, n3);
        System.arraycopy(byArray2, 0, byArray3, n4, byArray2.length);
        System.arraycopy(byArray, n4, byArray3, n4 + byArray2.length, byArray.length - n4);
        return byArray3;
    }
}

