/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.BlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.StreamCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.MD5Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA1Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA256Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA384Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.digests.SHA512Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.AESFastEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.CamelliaEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.DESedeEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.RC4Engine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.engines.SEEDEngine;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.AEADBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.CBCBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.modes.GCMBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.AbstractTlsCipherFactory;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsAEADCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsBlockCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsNullCipher;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsStreamCipher;
import java.io.IOException;

public class DefaultTlsCipherFactory
extends AbstractTlsCipherFactory {
    public TlsCipher createCipher(TlsContext tlsContext, int n2, int n3) throws IOException {
        switch (n2) {
            case 7: {
                return this.createDESedeCipher(tlsContext, n3);
            }
            case 8: {
                return this.createAESCipher(tlsContext, 16, n3);
            }
            case 10: {
                return this.createCipher_AES_GCM(tlsContext, 16, 16);
            }
            case 9: {
                return this.createAESCipher(tlsContext, 32, n3);
            }
            case 11: {
                return this.createCipher_AES_GCM(tlsContext, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(tlsContext, 16, n3);
            }
            case 13: {
                return this.createCamelliaCipher(tlsContext, 32, n3);
            }
            case 0: {
                return this.createNullCipher(tlsContext, n3);
            }
            case 2: {
                return this.createRC4Cipher(tlsContext, 16, n3);
            }
            case 14: {
                return this.createSEEDCipher(tlsContext, n3);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsBlockCipher createAESCipher(TlsContext tlsContext, int n2, int n3) throws IOException {
        return new TlsBlockCipher(tlsContext, this.createAESBlockCipher(), this.createAESBlockCipher(), this.createHMACDigest(n3), this.createHMACDigest(n3), n2);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsContext tlsContext, int n2, int n3) throws IOException {
        return new TlsAEADCipher(tlsContext, this.createAEADBlockCipher_AES_GCM(), this.createAEADBlockCipher_AES_GCM(), n2, n3);
    }

    protected TlsBlockCipher createCamelliaCipher(TlsContext tlsContext, int n2, int n3) throws IOException {
        return new TlsBlockCipher(tlsContext, this.createCamelliaBlockCipher(), this.createCamelliaBlockCipher(), this.createHMACDigest(n3), this.createHMACDigest(n3), n2);
    }

    protected TlsNullCipher createNullCipher(TlsContext tlsContext, int n2) throws IOException {
        return new TlsNullCipher(tlsContext, this.createHMACDigest(n2), this.createHMACDigest(n2));
    }

    protected TlsStreamCipher createRC4Cipher(TlsContext tlsContext, int n2, int n3) throws IOException {
        return new TlsStreamCipher(tlsContext, this.createRC4StreamCipher(), this.createRC4StreamCipher(), this.createHMACDigest(n3), this.createHMACDigest(n3), n2);
    }

    protected TlsBlockCipher createDESedeCipher(TlsContext tlsContext, int n2) throws IOException {
        return new TlsBlockCipher(tlsContext, this.createDESedeBlockCipher(), this.createDESedeBlockCipher(), this.createHMACDigest(n2), this.createHMACDigest(n2), 24);
    }

    protected TlsBlockCipher createSEEDCipher(TlsContext tlsContext, int n2) throws IOException {
        return new TlsBlockCipher(tlsContext, this.createSEEDBlockCipher(), this.createSEEDBlockCipher(), this.createHMACDigest(n2), this.createHMACDigest(n2), 16);
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(new AESFastEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(new AESFastEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(new CamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    protected Digest createHMACDigest(int n2) throws IOException {
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA256Digest();
            }
            case 4: {
                return new SHA384Digest();
            }
            case 5: {
                return new SHA512Digest();
            }
        }
        throw new TlsFatalAlert(80);
    }
}

