/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.CryptoException;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.RSAKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.Certificate;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsContext;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsDSSSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsECDSASigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsRSASigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import java.io.IOException;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsContext context;
    protected Certificate certificate;
    protected AsymmetricKeyParameter privateKey;
    protected TlsSigner signer;

    public DefaultTlsSignerCredentials(TlsContext tlsContext, Certificate certificate, AsymmetricKeyParameter asymmetricKeyParameter) {
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (asymmetricKeyParameter == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            this.signer = new TlsRSASigner();
        } else if (asymmetricKeyParameter instanceof DSAPrivateKeyParameters) {
            this.signer = new TlsDSSSigner();
        } else if (asymmetricKeyParameter instanceof ECPrivateKeyParameters) {
            this.signer = new TlsECDSASigner();
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + asymmetricKeyParameter.getClass().getName());
        }
        this.signer.init(tlsContext);
        this.context = tlsContext;
        this.certificate = certificate;
        this.privateKey = asymmetricKeyParameter;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public byte[] generateCertificateSignature(byte[] byArray) throws IOException {
        try {
            return this.signer.generateRawSignature(this.privateKey, byArray);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80);
        }
    }
}

