/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Signer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.SignerInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DHParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CombinedHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsDHUtils;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int n2, Vector vector, DHParameters dHParameters) {
        super(n2, vector, dHParameters);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
        dHKeyPairGenerator.init(new DHKeyGenerationParameters(this.context.getSecureRandom(), this.dhParameters));
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = dHKeyPairGenerator.generateKeyPair();
        BigInteger bigInteger = ((DHPublicKeyParameters)asymmetricCipherKeyPair.getPublic()).getY();
        TlsDHUtils.writeDHParameter(this.dhParameters.getP(), byteArrayOutputStream);
        TlsDHUtils.writeDHParameter(this.dhParameters.getG(), byteArrayOutputStream);
        TlsDHUtils.writeDHParameter(bigInteger, byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        CombinedHash combinedHash = new CombinedHash();
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        combinedHash.update(securityParameters.b, 0, securityParameters.b.length);
        combinedHash.update(securityParameters.c, 0, securityParameters.c.length);
        combinedHash.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[combinedHash.getDigestSize()];
        combinedHash.doFinal(byArray2, 0);
        byte[] byArray3 = this.serverCredentials.generateCertificateSignature(byArray2);
        TlsUtils.writeOpaque16(byArray3, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initVerifyer(this.tlsSigner, securityParameters);
        SignerInputStream signerInputStream = new SignerInputStream(inputStream, signer);
        BigInteger bigInteger = TlsDHUtils.readDHParameter(signerInputStream);
        BigInteger bigInteger2 = TlsDHUtils.readDHParameter(signerInputStream);
        BigInteger bigInteger3 = TlsDHUtils.readDHParameter(signerInputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        if (!signer.verifySignature(byArray)) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreeServerPublicKey = this.validateDHPublicKey(new DHPublicKeyParameters(bigInteger3, new DHParameters(bigInteger, bigInteger2)));
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.b, 0, securityParameters.b.length);
        signer.update(securityParameters.c, 0, securityParameters.c.length);
        return signer;
    }
}

