/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.crypto.tls;

import com.zeroturnaround.bundled.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Signer;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.io.SignerInputStream;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECDomainParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CertificateRequest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.CombinedHash;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.SecurityParameters;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsECCUtils;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsECDHKeyExchange;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsFatalAlert;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsProtocol;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSigner;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsECDHEKeyExchange(int n2, Vector vector, int[] nArray, short[] sArray, short[] sArray2) {
        super(n2, vector, nArray, sArray, sArray2);
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(tlsCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)tlsCredentials;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        int n2 = -1;
        if (this.namedCurves == null) {
            n2 = 23;
        } else {
            for (int i2 = 0; i2 < this.namedCurves.length; ++i2) {
                int n3 = this.namedCurves[i2];
                if (!TlsECCUtils.isSupportedNamedCurve(n3)) continue;
                n2 = n3;
                break;
            }
        }
        ECDomainParameters eCDomainParameters = null;
        if (n2 >= 0) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(n2);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65281)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(23);
        } else if (TlsProtocol.arrayContains(this.namedCurves, 65282)) {
            eCDomainParameters = TlsECCUtils.getParametersForNamedCurve(7);
        }
        if (eCDomainParameters == null) {
            throw new TlsFatalAlert(80);
        }
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = TlsECCUtils.generateECKeyPair(this.context.getSecureRandom(), eCDomainParameters);
        this.ecAgreeServerPrivateKey = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
        byte[] byArray = TlsECCUtils.serializeECPublicKey(this.clientECPointFormats, (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (n2 < 0) {
            TlsECCUtils.writeExplicitECParameters(this.clientECPointFormats, eCDomainParameters, byteArrayOutputStream);
        } else {
            TlsECCUtils.writeNamedECParameters(n2, byteArrayOutputStream);
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        CombinedHash combinedHash = new CombinedHash();
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        combinedHash.update(securityParameters.b, 0, securityParameters.b.length);
        combinedHash.update(securityParameters.c, 0, securityParameters.c.length);
        combinedHash.update(byArray2, 0, byArray2.length);
        byte[] byArray3 = new byte[combinedHash.getDigestSize()];
        combinedHash.doFinal(byArray3, 0);
        byte[] byArray4 = this.serverCredentials.generateCertificateSignature(byArray3);
        TlsUtils.writeOpaque16(byArray4, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        Signer signer = this.initVerifyer(this.tlsSigner, securityParameters);
        SignerInputStream signerInputStream = new SignerInputStream(inputStream, signer);
        ECDomainParameters eCDomainParameters = TlsECCUtils.readECParameters(this.namedCurves, this.clientECPointFormats, signerInputStream);
        byte[] byArray = TlsUtils.readOpaque8(signerInputStream);
        byte[] byArray2 = TlsUtils.readOpaque16(inputStream);
        if (!signer.verifySignature(byArray2)) {
            throw new TlsFatalAlert(51);
        }
        this.ecAgreeServerPublicKey = TlsECCUtils.validateECPublicKey(TlsECCUtils.deserializeECPublicKey(this.clientECPointFormats, eCDomainParameters, byArray));
    }

    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] sArray = certificateRequest.getCertificateTypes();
        block3: for (int i2 = 0; i2 < sArray.length; ++i2) {
            switch (sArray[i2]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (!(tlsCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(this.serverPublicKey);
        signer.update(securityParameters.b, 0, securityParameters.b.length);
        signer.update(securityParameters.c, 0, securityParameters.c.length);
        return signer;
    }
}

