/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.ec;

import com.zeroturnaround.bundled.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.DSA;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.Digest;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.zeroturnaround.bundled.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.DSABase;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.DSAEncoder;
import com.zeroturnaround.bundled.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.ECKey;
import com.zeroturnaround.bundled.org.bouncycastle.jce.interfaces.ECPublicKey;
import com.zeroturnaround.bundled.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;

public class SignatureSpi
extends DSABase {
    SignatureSpi(Digest digest, DSA dSA, DSAEncoder dSAEncoder) {
        super("ECDSA", digest, dSA, dSAEncoder);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (publicKey instanceof ECPublicKey) {
            asymmetricKeyParameter = ECUtil.generatePublicKeyParameter(publicKey);
        } else {
            try {
                byte[] byArray = publicKey.getEncoded();
                publicKey = BouncyCastleProvider.getPublicKey(SubjectPublicKeyInfo.getInstance(byArray));
                if (!(publicKey instanceof ECPublicKey)) {
                    throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
                }
                asymmetricKeyParameter = ECUtil.generatePublicKeyParameter(publicKey);
            }
            catch (Exception exception) {
                throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
            }
        }
        this.digest.reset();
        this.signer.init(false, asymmetricKeyParameter);
    }

    protected void doEngineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(privateKey instanceof ECKey)) {
            throw new InvalidKeyException("can't recognise key type in ECDSA based signer");
        }
        AsymmetricKeyParameter asymmetricKeyParameter = ECUtil.generatePrivateKeyParameter(privateKey);
        this.digest.reset();
        if (secureRandom != null) {
            this.signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, secureRandom));
        } else {
            this.signer.init(true, asymmetricKeyParameter);
        }
    }
}

